/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierUploadType;
import kafka.tier.serdes.OpaqueDataField;
import kafka.tier.serdes.TierPartitionStateEntry;
import kafka.tier.store.TierObjectStore;
import kafka.utils.CoreUtils;

public class TierObjectMetadata {
    private final TopicIdPartition topicIdPartition;
    private final TierPartitionStateEntry metadata;
    private int virtualBaseOffsetDeltaCached;
    private static final byte VERSION_V0 = 0;
    private static final byte VERSION_V1 = 1;
    private static final byte VERSION_V2 = 2;
    public static final byte CURRENT_VERSION = 2;
    private static final int INITIAL_BUFFER_SIZE = 136;
    public static final long DEFAULT_STATE_CHANGE_TIMESTAMP = Long.MAX_VALUE;
    public static final int UNKNOWN_VIRTUAL_OFFSET = -1;
    private final boolean includeCompactionFields;
    private final boolean includeStateChangeTimestamp;

    public TierObjectMetadata(TopicIdPartition topicIdPartition, TierPartitionStateEntry metadata) {
        this.topicIdPartition = topicIdPartition;
        this.metadata = metadata;
        this.virtualBaseOffsetDeltaCached = metadata.virtualBaseOffsetDelta();
        this.includeCompactionFields = this.compactionFieldsIncluded();
        this.includeStateChangeTimestamp = this.hasStateChangeTimestamp();
    }

    public TierObjectMetadata(TopicIdPartition topicIdPartition, int tierEpoch, UUID objectId, long baseOffset, long endOffset, long maxTimestamp, long firstBatchTimestamp, int size, State state, boolean hasEpochState, boolean hasAbortedTxns, boolean hasProducerState, TierUploadType uploadType, TierObjectStore.OpaqueData opaqueData, boolean includeCompactionFields, boolean includeStateChangeTimestamp, long stateChangeTimestamp) {
        this(topicIdPartition, 2, tierEpoch, objectId, baseOffset, -1L, endOffset, maxTimestamp, firstBatchTimestamp, size, state, hasEpochState, hasAbortedTxns, hasProducerState, uploadType, opaqueData, includeCompactionFields, includeStateChangeTimestamp, stateChangeTimestamp, State.INVALID);
    }

    @JsonCreator
    public TierObjectMetadata(@JsonProperty(value="topicIdPartition") TopicIdPartition topicIdPartition, @JsonProperty(value="version") byte version, @JsonProperty(value="tierEpoch") int tierEpoch, @JsonProperty(value="objectId") UUID objectId, @JsonProperty(value="baseOffset") long baseOffset, @JsonProperty(value="virtualBaseOffset") long virtualBaseOffset, @JsonProperty(value="endOffset") long endOffset, @JsonProperty(value="maxTimestamp") long maxTimestamp, @JsonProperty(value="firstBatchTimestamp") long firstBatchTimestamp, @JsonProperty(value="size") int size, @JsonProperty(value="state") State state, @JsonProperty(value="hasEpochState") boolean hasEpochState, @JsonProperty(value="hasAbortedTxns") boolean hasAbortedTxns, @JsonProperty(value="hasProducerState") boolean hasProducerState, @JsonProperty(value="uploadType") TierUploadType uploadType, @JsonProperty(value="opaqueData") TierObjectStore.OpaqueData opaqueData, @JsonProperty(value="includeCompactionFields") boolean includeCompactionFields, @JsonProperty(value="includeStateChangeTimestamp") boolean includeStateChangeTimestamp, @JsonProperty(value="stateChangeTimestamp") long stateChangeTimestamp, @JsonProperty(value="stateBeforeDeletion") State stateBeforeDeletion) {
        if (tierEpoch < 0) {
            throw new IllegalArgumentException(String.format("Illegal tierEpoch supplied %d.", tierEpoch));
        }
        FlatBufferBuilder builder = new FlatBufferBuilder(136).forceDefaults(true);
        TierPartitionStateEntry.startTierPartitionStateEntry(builder);
        TierPartitionStateEntry.addVersion(builder, version);
        TierPartitionStateEntry.addTierEpoch(builder, tierEpoch);
        int objectIdOffset = kafka.tier.serdes.UUID.createUUID(builder, objectId.getMostSignificantBits(), objectId.getLeastSignificantBits());
        TierPartitionStateEntry.addObjectId(builder, objectIdOffset);
        TierPartitionStateEntry.addBaseOffset(builder, baseOffset);
        TierPartitionStateEntry.addEndOffsetDelta(builder, (int)(endOffset - baseOffset));
        TierPartitionStateEntry.addMaxTimestamp(builder, maxTimestamp);
        TierPartitionStateEntry.addSize(builder, size);
        TierPartitionStateEntry.addState(builder, state.id());
        TierPartitionStateEntry.addHasEpochState(builder, hasEpochState);
        TierPartitionStateEntry.addHasAbortedTxns(builder, hasAbortedTxns);
        TierPartitionStateEntry.addHasProducerState(builder, hasProducerState);
        if (!opaqueData.equals(TierObjectStore.OpaqueData.ZEROED)) {
            long[] arr = opaqueData.intoLongArray();
            int opaqueDataOffset = OpaqueDataField.createOpaqueDataField(builder, arr[0], arr[1], arr[2], arr[3]);
            TierPartitionStateEntry.addOpaqueData(builder, opaqueDataOffset);
        }
        int n = this.virtualBaseOffsetDeltaCached = virtualBaseOffset == -1L ? -1 : (int)(virtualBaseOffset - baseOffset);
        if (includeCompactionFields) {
            TierPartitionStateEntry.addFirstBatchTimestamp(builder, firstBatchTimestamp);
            TierPartitionStateEntry.addUploadType(builder, TierUploadType.toByte(uploadType));
            TierPartitionStateEntry.addVirtualBaseOffsetDelta(builder, this.virtualBaseOffsetDeltaCached);
            TierPartitionStateEntry.addStateBeforeDeletion(builder, stateBeforeDeletion.id());
        }
        if (includeStateChangeTimestamp) {
            TierPartitionStateEntry.addStateChangeTimestamp(builder, stateChangeTimestamp);
        }
        int entryId = TierPartitionStateEntry.endTierPartitionStateEntry(builder);
        builder.finish(entryId);
        this.topicIdPartition = topicIdPartition;
        this.metadata = TierPartitionStateEntry.getRootAsTierPartitionStateEntry(builder.dataBuffer());
        this.includeCompactionFields = includeCompactionFields;
        this.includeStateChangeTimestamp = includeStateChangeTimestamp;
    }

    public TierObjectMetadata(TierSegmentUploadInitiate uploadInitiate, boolean includeCompactionFields, boolean includeStateChangeTimestamp) {
        this(uploadInitiate.topicIdPartition(), 2, uploadInitiate.tierEpoch(), uploadInitiate.objectId(), uploadInitiate.baseOffset(), -1L, uploadInitiate.endOffset(), uploadInitiate.maxTimestamp(), uploadInitiate.firstBatchTimestamp(), uploadInitiate.size(), uploadInitiate.state(), uploadInitiate.hasEpochState(), uploadInitiate.hasAbortedTxns(), uploadInitiate.hasProducerState(), uploadInitiate.uploadType(), uploadInitiate.opaqueData(), includeCompactionFields, includeStateChangeTimestamp, uploadInitiate.timestamp(), State.INVALID);
    }

    public static int initialBufferSize() {
        return 136;
    }

    @JsonProperty(value="topicIdPartition", required=true)
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public ByteBuffer payloadBuffer() {
        return this.metadata.getByteBuffer().duplicate();
    }

    public int payloadSize() {
        return this.metadata.getByteBuffer().remaining();
    }

    @JsonProperty(value="includeCompactionFields", required=true)
    public boolean includeCompactionFields() {
        return this.includeCompactionFields;
    }

    @JsonProperty(value="includeStateChangeTimestamp", required=true)
    public boolean includeStateChangeTimestamp() {
        return this.includeStateChangeTimestamp;
    }

    @JsonProperty(value="tierEpoch", required=true)
    public int tierEpoch() {
        return this.metadata.tierEpoch();
    }

    @JsonProperty(value="baseOffset", required=true)
    public long baseOffset() {
        return this.metadata.baseOffset();
    }

    @JsonProperty(value="virtualBaseOffset", required=true)
    public long virtualBaseOffset() {
        return this.virtualBaseOffsetDeltaCached == -1 ? this.baseOffset() : this.baseOffset() + (long)this.virtualBaseOffsetDeltaCached;
    }

    public boolean hasVirtualOffset() {
        return this.metadata.virtualBaseOffsetDelta() != -1;
    }

    public boolean boundOverlappingOffset(long newVirtualBaseOffset) {
        if (newVirtualBaseOffset < this.baseOffset()) {
            throw new IllegalStateException("virtualBaseOffset cannot be changed to smaller than baseOffset. baseOffset=" + this.baseOffset() + ", virtualBaseOffset=" + this.virtualBaseOffset() + ", new virtualBaseOffset=" + newVirtualBaseOffset);
        }
        this.virtualBaseOffsetDeltaCached = (int)(newVirtualBaseOffset - this.baseOffset());
        return this.metadata.mutateVirtualBaseOffsetDelta(this.virtualBaseOffsetDeltaCached);
    }

    @JsonProperty(value="objectId", required=true)
    public UUID objectId() {
        kafka.tier.serdes.UUID objectId = this.metadata.objectId();
        return new UUID(objectId.mostSignificantBits(), objectId.leastSignificantBits());
    }

    public String objectIdAsBase64() {
        return CoreUtils.uuidToBase64(this.objectId());
    }

    @JsonProperty(value="endOffset", required=true)
    public long endOffset() {
        return this.baseOffset() + (long)this.endOffsetDelta();
    }

    @JsonProperty(value="maxTimestamp", required=true)
    public long maxTimestamp() {
        return this.metadata.maxTimestamp();
    }

    @JsonProperty(value="firstBatchTimestamp", required=true)
    public long firstBatchTimestamp() {
        return this.metadata.firstBatchTimestamp();
    }

    @JsonProperty(value="size", required=true)
    public int size() {
        return this.metadata.size();
    }

    @JsonProperty(value="hasEpochState", required=true)
    public boolean hasEpochState() {
        return this.metadata.hasEpochState();
    }

    @JsonProperty(value="hasAbortedTxns", required=true)
    public boolean hasAbortedTxns() {
        return this.metadata.hasAbortedTxns();
    }

    @JsonProperty(value="state", required=true)
    public State state() {
        return State.toState(this.metadata.state());
    }

    public void mutateState(State newState) {
        if (!this.state().canTransitionTo(newState)) {
            throw new IllegalStateException("Cannot transition from " + (Object)((Object)this.state()) + " to " + (Object)((Object)newState));
        }
        this.metadata.mutateState(newState.id);
    }

    public void forceMutateState(State newState) {
        this.metadata.mutateState(newState.id);
    }

    @JsonProperty(value="hasProducerState", required=true)
    public boolean hasProducerState() {
        return this.metadata.hasProducerState();
    }

    @JsonProperty(value="uploadType", required=true)
    public TierUploadType uploadType() {
        return TierUploadType.fromByte(this.metadata.uploadType());
    }

    @JsonProperty(value="opaqueData", required=true)
    public TierObjectStore.OpaqueData opaqueData() {
        OpaqueDataField opaque = this.metadata.opaqueData();
        if (opaque == null) {
            return TierObjectStore.OpaqueData.ZEROED;
        }
        long[] arr = new long[]{opaque.f0(), opaque.f1(), opaque.f2(), opaque.f3()};
        return TierObjectStore.OpaqueData.fromLongArray(arr);
    }

    @JsonProperty(value="version", required=true)
    public short version() {
        return this.metadata.version();
    }

    private int endOffsetDelta() {
        return this.metadata.endOffsetDelta();
    }

    @JsonProperty(value="stateChangeTimestamp", required=true)
    public long stateChangeTimestamp() {
        return this.metadata.stateChangeTimestamp();
    }

    public boolean mutateStateChangeTimestamp(long newStateChangeTimestamp) {
        return this.metadata.mutateStateChangeTimestamp(newStateChangeTimestamp);
    }

    @JsonProperty(value="stateBeforeDeletion", required=true)
    public State stateBeforeDeletion() {
        return State.toState(this.metadata.stateBeforeDeletion());
    }

    public boolean mutateStateBeforeDeletion(State newState) {
        return this.metadata.mutateStateBeforeDeletion(newState.id);
    }

    public boolean hasStateBeforeDeletion() {
        State state = this.stateBeforeDeletion();
        return state.id() != State.INVALID.id() || this.mutateStateBeforeDeletion(state);
    }

    private boolean compactionFieldsIncluded() {
        return this.firstBatchTimestamp() >= 0L || this.uploadType() == TierUploadType.Compaction || this.hasVirtualOffset() || this.hasStateBeforeDeletion();
    }

    public boolean hasStateChangeTimestamp() {
        long stateChangeTimestamp = this.metadata.stateChangeTimestamp();
        return stateChangeTimestamp != -1L || this.metadata.mutateStateChangeTimestamp(stateChangeTimestamp);
    }

    public TierObjectMetadata migrateFormat(long currentTimeMs, boolean includeCompactionFields, boolean includeStateChangeTimestamp) {
        State state = this.state();
        long stateChangeTimestamp = this.stateChangeTimestamp();
        if (stateChangeTimestamp < 0L) {
            stateChangeTimestamp = state == State.SEGMENT_DELETE_COMPLETE ? currentTimeMs : Long.MAX_VALUE;
        }
        return new TierObjectMetadata(this.topicIdPartition(), (byte)this.version(), this.tierEpoch(), this.objectId(), this.baseOffset(), this.hasVirtualOffset() ? this.virtualBaseOffset() : -1L, this.endOffset(), this.maxTimestamp(), this.firstBatchTimestamp(), this.size(), state, this.hasEpochState(), this.hasAbortedTxns(), this.hasProducerState(), this.uploadType(), this.opaqueData(), includeCompactionFields || this.compactionFieldsIncluded(), includeStateChangeTimestamp, stateChangeTimestamp, this.stateBeforeDeletion());
    }

    public boolean isEligibleForCleanup(long maxDeleteTimestampForCleanup, boolean cleanupFeatureFlag) {
        if (!cleanupFeatureFlag) {
            return false;
        }
        long stateChangeTimestamp = this.stateChangeTimestamp();
        if (stateChangeTimestamp < 0L || this.state() != State.SEGMENT_DELETE_COMPLETE) {
            return false;
        }
        return stateChangeTimestamp <= maxDeleteTimestampForCleanup;
    }

    public String toString() {
        return "TierObjectMetadata(includeCompactionFields=" + this.includeCompactionFields() + ", " + "version" + "=" + this.version() + ", " + "topicIdPartition" + "=" + this.topicIdPartition() + ", " + "tierEpoch" + "=" + this.tierEpoch() + ", " + "objectIdAsBase64" + "=" + this.objectIdAsBase64() + ", " + "baseOffset" + "=" + this.baseOffset() + ", " + "virtualBaseOffset" + "=" + this.virtualBaseOffset() + ", " + "endOffset" + "=" + this.endOffset() + ", " + "maxTimestamp" + "=" + this.maxTimestamp() + ", " + "firstBatchTimestamp" + "=" + this.firstBatchTimestamp() + ", " + "size" + "=" + this.size() + ", " + "state" + "=" + (Object)((Object)this.state()) + ", " + "hasEpochState" + "=" + this.hasEpochState() + ", " + "hasAbortedTxns" + "=" + this.hasAbortedTxns() + ", " + "hasProducerState" + "=" + this.hasProducerState() + ", " + "uploadType" + "=" + (Object)((Object)this.uploadType()) + ", " + "stateChangeTimestamp" + "=" + this.stateChangeTimestamp() + ", " + "stateBeforeDeletion" + "=" + (Object)((Object)this.stateBeforeDeletion()) + ", " + "opaqueData" + "=" + this.opaqueData() + ")";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.topicIdPartition(), this.tierEpoch(), this.objectId(), this.baseOffset(), this.virtualBaseOffset(), this.endOffset(), this.maxTimestamp(), this.firstBatchTimestamp(), this.size(), this.state(), this.hasEpochState(), this.hasAbortedTxns(), this.hasProducerState(), this.uploadType(), this.stateChangeTimestamp(), this.stateBeforeDeletion(), this.opaqueData(), this.version()});
    }

    public boolean equalsExcludingStateAndChangeTimestamp(TierObjectMetadata that) {
        return Objects.equals(this.topicIdPartition(), that.topicIdPartition()) && Objects.equals(this.tierEpoch(), that.tierEpoch()) && Objects.equals(this.baseOffset(), that.baseOffset()) && Objects.equals(this.virtualBaseOffset(), that.virtualBaseOffset()) && Objects.equals(this.objectId(), that.objectId()) && Objects.equals(this.endOffset(), that.endOffset()) && Objects.equals(this.maxTimestamp(), that.maxTimestamp()) && Objects.equals(this.firstBatchTimestamp(), that.firstBatchTimestamp()) && Objects.equals(this.size(), that.size()) && Objects.equals(this.hasEpochState(), that.hasEpochState()) && Objects.equals(this.hasAbortedTxns(), that.hasAbortedTxns()) && Objects.equals(this.hasProducerState(), that.hasProducerState()) && Objects.equals((Object)this.uploadType(), (Object)that.uploadType()) && Objects.equals(this.opaqueData(), that.opaqueData()) && Objects.equals(this.version(), that.version());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TierObjectMetadata that = (TierObjectMetadata)o;
        return this.equalsExcludingStateAndChangeTimestamp(that) && Objects.equals((Object)this.state(), (Object)that.state()) && Objects.equals((Object)this.stateBeforeDeletion(), (Object)that.stateBeforeDeletion()) && this.stateChangeTimestamp() == that.stateChangeTimestamp();
    }

    public static enum State {
        SEGMENT_UPLOAD_INITIATE(0, Arrays.asList((byte)1, (byte)2, (byte)4)),
        SEGMENT_UPLOAD_COMPLETE(1, Arrays.asList((byte)2, (byte)5)),
        SEGMENT_DELETE_INITIATE(2, Arrays.asList((byte)3, (byte)4)),
        SEGMENT_DELETE_COMPLETE(3, Collections.emptyList()),
        SEGMENT_FENCED(4, Collections.singletonList((byte)2)),
        SEGMENT_COMPACTED(5, Collections.singletonList((byte)2)),
        INVALID(-1, Collections.emptyList());

        private static final Map<Byte, State> VALUES;
        private final byte id;
        private final List<Byte> nextStates;

        private State(byte id, List<Byte> nextStates) {
            this.id = id;
            this.nextStates = nextStates;
        }

        public byte id() {
            return this.id;
        }

        public static State toState(byte id) {
            State state = VALUES.get(id);
            if (state == null) {
                throw new IllegalArgumentException("No mapping found for " + id);
            }
            return state;
        }

        public boolean canTransitionTo(State newState) {
            State.raiseIfIllegal(this, newState);
            return this.nextStates.contains(newState.id);
        }

        private static void raiseIfIllegal(State currentState, State newState) {
            if (newState == SEGMENT_DELETE_COMPLETE && currentState != SEGMENT_DELETE_INITIATE) {
                throw new IllegalStateException("Illegal transition from " + (Object)((Object)currentState) + " to " + (Object)((Object)newState));
            }
        }

        static {
            VALUES = new HashMap<Byte, State>();
            for (State state : State.values()) {
                State previousState = VALUES.put(state.id, state);
                if (previousState == null) continue;
                throw new ExceptionInInitializerError("Conflicting VALUES for " + (Object)((Object)previousState) + " and " + (Object)((Object)state));
            }
        }
    }
}

