/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser;

import io.confluent.ksql.metastore.TypeRegistry;
import io.confluent.ksql.parser.AstBuilder;
import io.confluent.ksql.parser.CaseInsensitiveStream;
import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.ParsingException;
import io.confluent.ksql.parser.SqlBaseLexer;
import io.confluent.ksql.parser.SqlBaseParser;
import io.confluent.ksql.parser.SyntaxErrorValidator;
import io.confluent.ksql.parser.exception.ParseFailedException;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlStatementException;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.misc.ParseCancellationException;

public class DefaultKsqlParser
implements KsqlParser {
    public static final BaseErrorListener ERROR_VALIDATOR = new SyntaxErrorValidator();

    @Override
    public List<KsqlParser.ParsedStatement> parse(String sql) {
        try {
            SqlBaseParser.StatementsContext statementsContext = DefaultKsqlParser.getParseTree(sql);
            return statementsContext.singleStatement().stream().map(DefaultKsqlParser::parsedStatement).collect(Collectors.toList());
        }
        catch (ParsingException e) {
            String failedLine = sql.split(System.lineSeparator())[e.getLineNumber() - 1];
            throw new ParseFailedException(e.getMessage(), e.getUnloggedDetails(), failedLine, e);
        }
        catch (KsqlStatementException e) {
            throw new ParseFailedException(e.getMessage(), e.getUnloggedMessage(), sql, e);
        }
        catch (Exception e) {
            throw new ParseFailedException(e.getMessage(), sql, e);
        }
    }

    public static KsqlParser.ParsedStatement parsedStatement(SqlBaseParser.SingleStatementContext statement) {
        return KsqlParser.ParsedStatement.of(DefaultKsqlParser.getStatementString(statement), statement);
    }

    @Override
    public KsqlParser.PreparedStatement<?> prepare(KsqlParser.ParsedStatement stmt, TypeRegistry typeRegistry) {
        try {
            AstBuilder astBuilder = new AstBuilder(typeRegistry);
            Statement root = astBuilder.buildStatement(stmt.getStatement());
            return KsqlParser.PreparedStatement.of(stmt.getUnMaskedStatementText(), root);
        }
        catch (ParseFailedException e) {
            if (!e.getSqlStatement().isEmpty()) {
                throw e;
            }
            throw new ParseFailedException(e.getRawMessage(), stmt.getMaskedStatementText(), e.getCause());
        }
        catch (ParsingException e) {
            throw new ParseFailedException("Failed to prepare statement: " + e.getMessage(), "Failed to prepare statement: " + e.getUnloggedDetails(), stmt.getMaskedStatementText(), e);
        }
        catch (Exception e) {
            throw new ParseFailedException("Failed to prepare statement: " + e.getMessage(), stmt.getMaskedStatementText(), e);
        }
    }

    public static SqlBaseParser.StatementsContext getParseTree(String sql) {
        SqlBaseLexer sqlBaseLexer = new SqlBaseLexer(new CaseInsensitiveStream((CharStream)CharStreams.fromString((String)sql)));
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)sqlBaseLexer);
        SqlBaseParser sqlBaseParser = new SqlBaseParser((TokenStream)tokenStream);
        sqlBaseLexer.removeErrorListeners();
        sqlBaseLexer.addErrorListener((ANTLRErrorListener)ERROR_VALIDATOR);
        sqlBaseParser.removeErrorListeners();
        sqlBaseParser.addErrorListener((ANTLRErrorListener)ERROR_VALIDATOR);
        Function<SqlBaseParser, ParserRuleContext> parseFunction = SqlBaseParser::statements;
        try {
            ((ParserATNSimulator)sqlBaseParser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            return (SqlBaseParser.StatementsContext)parseFunction.apply(sqlBaseParser);
        }
        catch (ParseCancellationException ex) {
            tokenStream.seek(0);
            sqlBaseParser.reset();
            ((ParserATNSimulator)sqlBaseParser.getInterpreter()).setPredictionMode(PredictionMode.LL);
            return (SqlBaseParser.StatementsContext)parseFunction.apply(sqlBaseParser);
        }
        catch (StackOverflowError e) {
            throw new KsqlException("Error processing statement: Statement is too large to parse. This may be caused by having too many nested expressions in the statement.");
        }
    }

    private static String getStatementString(SqlBaseParser.SingleStatementContext singleStatementContext) {
        CharStream charStream = singleStatementContext.start.getInputStream();
        return charStream.getText(Interval.of((int)singleStatementContext.start.getStartIndex(), (int)singleStatementContext.stop.getStopIndex()));
    }
}

