/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Statement;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class AlterSystemProperty
extends Statement {
    private final String propertyName;
    private final String propertyValue;

    public AlterSystemProperty(Optional<NodeLocation> location, String propertyName, String propertyValue) {
        super(location);
        this.propertyName = Objects.requireNonNull(propertyName, "propertyName");
        this.propertyValue = Objects.requireNonNull(propertyValue, "propertyValue");
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAlterSystemProperty(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AlterSystemProperty that = (AlterSystemProperty)((Object)o);
        return Objects.equals(this.propertyName, that.propertyName) && Objects.equals(this.propertyValue, that.propertyValue);
    }

    public int hashCode() {
        return Objects.hash(this.propertyName, this.propertyValue);
    }

    public String toString() {
        return "AlterSystemProperty{propertyName='" + this.propertyName + '\'' + ", propertyValue='" + this.propertyValue + '\'' + '}';
    }
}

