/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.windows.WindowTimeClause;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AssertResource;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class AssertSchema
extends AssertResource {
    private final Optional<String> subject;
    private final Optional<Integer> id;

    public AssertSchema(Optional<NodeLocation> location, Optional<String> subject, Optional<Integer> id, Optional<WindowTimeClause> timeout, boolean exists) {
        super(location, timeout, exists);
        this.subject = Objects.requireNonNull(subject, "subject");
        this.id = Objects.requireNonNull(id, "id");
    }

    public Optional<String> getSubject() {
        return this.subject;
    }

    public Optional<Integer> getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AssertSchema that = (AssertSchema)((Object)o);
        return this.subject.equals(that.subject) && this.id.equals(that.id) && this.timeout.equals(that.timeout) && this.exists == that.exists;
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.id, this.timeout, this.exists);
    }

    public String toString() {
        return "AssertSchema{subject=" + this.subject + ",id=" + this.id + ",timeout=" + this.timeout + ",exists=" + this.exists + '}';
    }
}

