/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.analyzer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.confluent.ksql.analyzer.AggregateAnalysisResult;
import io.confluent.ksql.analyzer.ImmutableAnalysis;
import io.confluent.ksql.analyzer.MutableAggregateAnalysis;
import io.confluent.ksql.execution.expression.tree.ColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.expression.tree.QualifiedColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.TraversalExpressionVisitor;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.execution.plan.SelectExpression;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.FunctionName;
import io.confluent.ksql.parser.tree.GroupBy;
import io.confluent.ksql.schema.ksql.SystemColumns;
import io.confluent.ksql.util.KsqlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class AggregateAnalyzer {
    private final FunctionRegistry functionRegistry;

    public AggregateAnalyzer(FunctionRegistry functionRegistry) {
        this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry");
    }

    public AggregateAnalysisResult analyze(ImmutableAnalysis analysis, List<SelectExpression> finalProjection) {
        if (!analysis.getGroupBy().isPresent()) {
            throw new IllegalArgumentException("Not an aggregate query");
        }
        AggAnalyzer aggAnalyzer = new AggAnalyzer(analysis, this.functionRegistry);
        aggAnalyzer.process(finalProjection);
        return aggAnalyzer.result();
    }

    private static final class AggregateVisitor
    extends TraversalExpressionVisitor<Void> {
        private final BiConsumer<Optional<FunctionName>, Expression> dereferenceCollector;
        private final ColumnReferenceExp defaultArgument;
        private final MutableAggregateAnalysis aggregateAnalysis;
        private final FunctionRegistry functionRegistry;
        private final Set<Expression> groupBy;
        private Expression currentlyInExpressionPartOfGroupBy;
        private Optional<FunctionName> aggFunctionName = Optional.empty();
        private boolean currentlyInAggregateFunction = false;

        private AggregateVisitor(AggAnalyzer aggAnalyzer, Set<Expression> groupBy, BiConsumer<Optional<FunctionName>, Expression> dereferenceCollector) {
            this.defaultArgument = aggAnalyzer.analysis.getDefaultArgument();
            this.aggregateAnalysis = aggAnalyzer.aggregateAnalysis;
            this.functionRegistry = aggAnalyzer.functionRegistry;
            this.groupBy = groupBy;
            this.dereferenceCollector = Objects.requireNonNull(dereferenceCollector, "dereferenceCollector");
        }

        public Void process(Expression node, Void context) {
            if (this.groupBy.contains(node) && this.currentlyInExpressionPartOfGroupBy == null) {
                this.currentlyInExpressionPartOfGroupBy = node;
            }
            super.process(node, (Object)context);
            if (this.currentlyInExpressionPartOfGroupBy != null && this.currentlyInExpressionPartOfGroupBy == node) {
                this.currentlyInExpressionPartOfGroupBy = null;
            }
            return null;
        }

        public Void visitFunctionCall(FunctionCall node, Void context) {
            FunctionCall functionCall;
            FunctionName functionName = node.getName();
            if (!this.functionRegistry.isPresent(functionName)) {
                throw new KsqlException("Can't find any functions with the name '" + functionName.text() + "'");
            }
            boolean aggregateFunc = this.functionRegistry.isAggregate(functionName);
            FunctionCall functionCall2 = functionCall = aggregateFunc && node.getArguments().isEmpty() ? new FunctionCall(node.getLocation(), node.getName(), (List)ImmutableList.of((Object)this.defaultArgument)) : node;
            if (aggregateFunc) {
                if (this.aggFunctionName.isPresent()) {
                    throw new KsqlException("Aggregate functions can not be nested: " + this.aggFunctionName.get().text() + "(" + functionName.text() + "())");
                }
                this.currentlyInAggregateFunction = true;
                this.aggFunctionName = Optional.of(functionName);
                functionCall.getArguments().forEach(this.aggregateAnalysis::addAggregateFunctionArgument);
                this.aggregateAnalysis.addAggFunction(functionCall);
            }
            super.visitFunctionCall(functionCall, (Object)context);
            if (aggregateFunc) {
                this.aggFunctionName = Optional.empty();
            }
            return null;
        }

        public Void visitUnqualifiedColumnReference(UnqualifiedColumnReferenceExp node, Void context) {
            if (this.currentlyInExpressionPartOfGroupBy == null || this.currentlyInAggregateFunction || SystemColumns.isWindowBound((ColumnName)node.getColumnName())) {
                this.dereferenceCollector.accept(this.aggFunctionName, (Expression)node);
            }
            if (!SystemColumns.isWindowBound((ColumnName)node.getColumnName())) {
                this.aggregateAnalysis.addRequiredColumn((ColumnReferenceExp)node);
            }
            return null;
        }

        public Void visitQualifiedColumnReference(QualifiedColumnReferenceExp node, Void context) {
            throw new UnsupportedOperationException("Should of been converted to unqualified");
        }
    }

    private static final class AggAnalyzer {
        private final ImmutableAnalysis analysis;
        private final MutableAggregateAnalysis aggregateAnalysis = new MutableAggregateAnalysis();
        private final FunctionRegistry functionRegistry;
        private final Set<Expression> groupBy;
        private final List<Expression> nonAggSelectsNotPartOfGroupBy = new ArrayList<Expression>();
        private final List<Expression> nonAggHavingNotPartOfGroupBy = new ArrayList<Expression>();

        AggAnalyzer(ImmutableAnalysis analysis, FunctionRegistry functionRegistry) {
            this.analysis = Objects.requireNonNull(analysis, "analysis");
            this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry");
            this.groupBy = AggAnalyzer.getGroupByExpressions(analysis);
        }

        public void process(List<SelectExpression> finalProjection) {
            finalProjection.stream().map(SelectExpression::getExpression).forEach(this::processSelect);
            this.analysis.getWhereExpression().ifPresent(this::processWhere);
            this.analysis.getGroupBy().map(GroupBy::getGroupingExpressions).orElseGet(ImmutableList::of).forEach(this::processGroupBy);
            this.analysis.getHavingExpression().ifPresent(this::processHaving);
        }

        private void processSelect(Expression expression) {
            HashSet<Expression> nonAggParams = new HashSet<Expression>();
            AggregateVisitor visitor = new AggregateVisitor(this, this.groupBy, (aggFuncName, node) -> {
                if (aggFuncName.isPresent()) {
                    this.throwOnWindowBoundColumnIfWindowedAggregate((Expression)node);
                } else if (!this.groupBy.contains(node)) {
                    nonAggParams.add((Expression)node);
                }
            });
            visitor.process(expression, null);
            this.captureNonAggregateSelectNotPartOfGroupBy(expression, nonAggParams);
            this.aggregateAnalysis.addFinalSelectExpression(expression);
        }

        private void processGroupBy(Expression expression) {
            AggregateVisitor visitor = new AggregateVisitor(this, this.groupBy, (aggFuncName, node) -> {
                if (aggFuncName.isPresent()) {
                    throw new KsqlException("GROUP BY does not support aggregate functions: " + ((FunctionName)aggFuncName.get()).text() + " is an aggregate function.");
                }
                this.throwOnWindowBoundColumnIfWindowedAggregate((Expression)node);
            });
            visitor.process(expression, null);
        }

        private void processWhere(Expression expression) {
            AggregateVisitor visitor = new AggregateVisitor(this, this.groupBy, (aggFuncName, node) -> this.throwOnWindowBoundColumnIfWindowedAggregate((Expression)node));
            visitor.process(expression, null);
        }

        private void processHaving(Expression expression) {
            AggregateVisitor visitor = new AggregateVisitor(this, this.groupBy, (aggFuncName, node) -> {
                this.throwOnWindowBoundColumnIfWindowedAggregate((Expression)node);
                if (!aggFuncName.isPresent()) {
                    this.captureNonAggregateHavingNotPartOfGroupBy((Expression)node);
                }
            });
            visitor.process(expression, null);
            this.aggregateAnalysis.setHavingExpression(expression);
        }

        private void throwOnWindowBoundColumnIfWindowedAggregate(Expression node) {
            if (!this.analysis.getWindowExpression().isPresent()) {
                return;
            }
            if (!(node instanceof ColumnReferenceExp)) {
                return;
            }
            if (SystemColumns.isWindowBound((ColumnName)((ColumnReferenceExp)node).getColumnName())) {
                throw new KsqlException("Window bounds column " + node + " can only be used in the SELECT clause of windowed aggregations and can not be passed to aggregate functions." + System.lineSeparator() + "See https://github.com/confluentinc/ksql/issues/4397");
            }
        }

        private static Set<Expression> getGroupByExpressions(ImmutableAnalysis analysis) {
            List groupByExpressions = analysis.getGroupBy().map(GroupBy::getGroupingExpressions).orElseGet(ImmutableList::of);
            if (!analysis.getWindowExpression().isPresent()) {
                return ImmutableSet.copyOf((Collection)groupByExpressions);
            }
            Set windowBoundColumnRefs = SystemColumns.windowBoundsColumnNames().stream().map(UnqualifiedColumnReferenceExp::new).collect(Collectors.toSet());
            return ImmutableSet.builder().addAll((Iterable)groupByExpressions).addAll(windowBoundColumnRefs).build();
        }

        private void captureNonAggregateSelectNotPartOfGroupBy(Expression expression, Set<Expression> nonAggParams) {
            boolean matchesGroupBy = this.groupBy.contains(expression);
            if (matchesGroupBy) {
                return;
            }
            boolean onlyReferencesColumnsInGroupBy = Sets.difference(nonAggParams, this.groupBy).isEmpty();
            if (onlyReferencesColumnsInGroupBy) {
                return;
            }
            this.nonAggSelectsNotPartOfGroupBy.add(expression);
        }

        private void captureNonAggregateHavingNotPartOfGroupBy(Expression nonAggColumn) {
            if (this.groupBy.contains(nonAggColumn)) {
                return;
            }
            this.nonAggHavingNotPartOfGroupBy.add(nonAggColumn);
        }

        public AggregateAnalysisResult result() {
            this.enforceAggregateRules();
            return this.aggregateAnalysis;
        }

        private void enforceAggregateRules() {
            if (this.aggregateAnalysis.getAggregateFunctions().isEmpty()) {
                throw new KsqlException("GROUP BY requires aggregate functions in either the SELECT or HAVING clause.");
            }
            String unmatchedSelects = this.nonAggSelectsNotPartOfGroupBy.stream().map(Objects::toString).collect(Collectors.joining(", "));
            if (!unmatchedSelects.isEmpty()) {
                throw new KsqlException("Non-aggregate SELECT expression(s) not part of GROUP BY: " + unmatchedSelects + System.lineSeparator() + "Either add the column(s) to the GROUP BY or remove them from the SELECT.");
            }
            String havingOnly = this.nonAggHavingNotPartOfGroupBy.stream().map(Objects::toString).collect(Collectors.joining(", "));
            if (!havingOnly.isEmpty()) {
                throw new KsqlException("Non-aggregate HAVING expression not part of GROUP BY: " + havingOnly + System.lineSeparator() + "Consider switching the HAVING clause to a WHERE clause before the GROUP BY.");
            }
        }
    }
}

