/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.analyzer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.analyzer.ImmutableAnalysis;
import io.confluent.ksql.analyzer.SourceSchemas;
import io.confluent.ksql.execution.ddl.commands.KsqlTopic;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.expression.tree.QualifiedColumnReferenceExp;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.metastore.model.KsqlStream;
import io.confluent.ksql.metastore.model.KsqlTable;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.properties.with.CreateSourceAsProperties;
import io.confluent.ksql.parser.tree.GroupBy;
import io.confluent.ksql.parser.tree.PartitionBy;
import io.confluent.ksql.parser.tree.SelectItem;
import io.confluent.ksql.parser.tree.WindowExpression;
import io.confluent.ksql.parser.tree.WithinExpression;
import io.confluent.ksql.planner.plan.JoinNode;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.SystemColumns;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.RefinementInfo;
import io.confluent.ksql.serde.WindowInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Analysis
implements ImmutableAnalysis {
    private final Optional<RefinementInfo> refinementInfo;
    private final Function<Map<SourceName, LogicalSchema>, SourceSchemas> sourceSchemasFactory;
    private Optional<Into> into = Optional.empty();
    private final List<AliasedDataSource> allDataSources = new ArrayList<AliasedDataSource>();
    private final List<JoinInfo> joinInfo = new ArrayList<JoinInfo>();
    private Optional<Expression> whereExpression = Optional.empty();
    private final List<SelectItem> selectItems = new ArrayList<SelectItem>();
    private final Set<ColumnName> selectColumnNames = new HashSet<ColumnName>();
    private Optional<GroupBy> groupBy = Optional.empty();
    private Optional<PartitionBy> partitionBy = Optional.empty();
    private Optional<WindowExpression> windowExpression = Optional.empty();
    private Optional<Expression> havingExpression = Optional.empty();
    private OptionalInt limitClause = OptionalInt.empty();
    private CreateSourceAsProperties withProperties = CreateSourceAsProperties.none();
    private final List<FunctionCall> tableFunctions = new ArrayList<FunctionCall>();
    private final List<FunctionCall> aggregateFunctions = new ArrayList<FunctionCall>();
    private boolean orReplace = false;
    private boolean pullLimitClauseEnabled = true;

    public Analysis(Optional<RefinementInfo> refinementInfo, boolean pullLimitClauseEnabled) {
        this(refinementInfo, SourceSchemas::new, pullLimitClauseEnabled);
    }

    @VisibleForTesting
    Analysis(Optional<RefinementInfo> refinementInfo, Function<Map<SourceName, LogicalSchema>, SourceSchemas> sourceSchemasFactory, boolean pullLimitClauseEnabled) {
        this.refinementInfo = Objects.requireNonNull(refinementInfo, "refinementInfo");
        this.sourceSchemasFactory = Objects.requireNonNull(sourceSchemasFactory, "sourceSchemasFactory");
        this.pullLimitClauseEnabled = pullLimitClauseEnabled;
    }

    void addSelectItem(SelectItem selectItem) {
        this.selectItems.add(Objects.requireNonNull(selectItem, "selectItem"));
    }

    void addSelectColumnRefs(Collection<ColumnName> columnNames) {
        this.selectColumnNames.addAll(columnNames);
    }

    @Override
    public Optional<Into> getInto() {
        return this.into;
    }

    public void setInto(Into into) {
        this.into = Optional.of(into);
    }

    @Override
    public Optional<Expression> getWhereExpression() {
        return this.whereExpression;
    }

    void setWhereExpression(Expression whereExpression) {
        this.whereExpression = Optional.of(whereExpression);
    }

    @Override
    public List<SelectItem> getSelectItems() {
        return Collections.unmodifiableList(this.selectItems);
    }

    @Override
    public Set<ColumnName> getSelectColumnNames() {
        return Collections.unmodifiableSet(this.selectColumnNames);
    }

    @Override
    public Optional<WindowExpression> getWindowExpression() {
        return this.windowExpression;
    }

    void setWindowExpression(WindowExpression windowExpression) {
        this.windowExpression = Optional.of(windowExpression);
    }

    @Override
    public Optional<Expression> getHavingExpression() {
        return this.havingExpression;
    }

    void setHavingExpression(Expression havingExpression) {
        this.havingExpression = Optional.of(havingExpression);
    }

    @Override
    public Optional<GroupBy> getGroupBy() {
        return this.groupBy;
    }

    @Override
    public Optional<RefinementInfo> getRefinementInfo() {
        return this.refinementInfo;
    }

    void setGroupBy(GroupBy groupBy) {
        this.groupBy = Optional.of(groupBy);
    }

    @Override
    public Optional<PartitionBy> getPartitionBy() {
        return this.partitionBy;
    }

    void setPartitionBy(PartitionBy partitionBy) {
        this.partitionBy = Optional.of(partitionBy);
    }

    @Override
    public OptionalInt getLimitClause() {
        return this.limitClause;
    }

    void setLimitClause(int limitClause) {
        this.limitClause = OptionalInt.of(limitClause);
    }

    void addJoin(JoinInfo joinInfo) {
        this.joinInfo.add(joinInfo);
    }

    @Override
    public List<JoinInfo> getJoin() {
        return Collections.unmodifiableList(this.joinInfo);
    }

    @Override
    public boolean isJoin() {
        return !this.joinInfo.isEmpty();
    }

    @Override
    public List<AliasedDataSource> getAllDataSources() {
        return ImmutableList.copyOf(this.allDataSources);
    }

    @Override
    public SourceSchemas getFromSourceSchemas(boolean postAggregate) {
        Map<SourceName, LogicalSchema> schemaBySource = this.allDataSources.stream().collect(Collectors.toMap(AliasedDataSource::getAlias, ads -> this.buildStreamsSchema((AliasedDataSource)ads, postAggregate)));
        return this.sourceSchemasFactory.apply(schemaBySource);
    }

    Optional<AliasedDataSource> getSourceByAlias(SourceName name) {
        return this.allDataSources.stream().filter(source -> source.getAlias().equals((Object)name)).findFirst();
    }

    Optional<AliasedDataSource> getSourceByName(SourceName name) {
        return this.allDataSources.stream().filter(source -> source.getDataSource().getName().equals((Object)name)).findFirst();
    }

    @Override
    public AliasedDataSource getFrom() {
        return this.allDataSources.get(0);
    }

    @Override
    public boolean getOrReplace() {
        return this.orReplace;
    }

    public void setOrReplace(boolean orReplace) {
        this.orReplace = orReplace;
    }

    void addDataSource(SourceName alias, DataSource dataSource) {
        if (!(dataSource instanceof KsqlStream) && !(dataSource instanceof KsqlTable)) {
            throw new IllegalArgumentException("Data source type not supported yet: " + dataSource);
        }
        this.allDataSources.add(new AliasedDataSource(alias, dataSource));
    }

    public QualifiedColumnReferenceExp getDefaultArgument() {
        SourceName alias = this.allDataSources.get(0).getAlias();
        return new QualifiedColumnReferenceExp(alias, SystemColumns.ROWTIME_NAME);
    }

    void setProperties(CreateSourceAsProperties properties) {
        this.withProperties = Objects.requireNonNull(properties, "properties");
    }

    @Override
    public CreateSourceAsProperties getProperties() {
        return this.withProperties;
    }

    void addTableFunction(FunctionCall functionCall) {
        this.tableFunctions.add(Objects.requireNonNull(functionCall));
    }

    @Override
    public List<FunctionCall> getTableFunctions() {
        return Collections.unmodifiableList(this.tableFunctions);
    }

    void addAggregateFunction(FunctionCall functionCall) {
        this.aggregateFunctions.add(Objects.requireNonNull(functionCall));
    }

    @Override
    public List<FunctionCall> getAggregateFunctions() {
        return Collections.unmodifiableList(this.aggregateFunctions);
    }

    public boolean getPullLimitClauseEnabled() {
        return this.pullLimitClauseEnabled;
    }

    private LogicalSchema buildStreamsSchema(AliasedDataSource ds, boolean postAggregate) {
        boolean windowedSource = ds.getDataSource().getKsqlTopic().getKeyFormat().isWindowed();
        boolean windowedGroupBy = postAggregate && this.windowExpression.isPresent();
        return ds.getDataSource().getSchema().withPseudoAndKeyColsInValue(windowedSource || windowedGroupBy);
    }

    @Immutable
    public static final class JoinInfo {
        private final Expression leftJoinExpression;
        private final Expression rightJoinExpression;
        private final JoinNode.JoinType type;
        private final Optional<WithinExpression> withinExpression;
        private final AliasedDataSource leftSource;
        private final AliasedDataSource rightSource;
        private final boolean flippedJoinCondition;

        JoinInfo(AliasedDataSource leftSource, Expression leftJoinExpression, AliasedDataSource rightSource, Expression rightJoinExpression, JoinNode.JoinType type, boolean flippedJoinCondition, Optional<WithinExpression> withinExpression) {
            this.leftSource = Objects.requireNonNull(leftSource, "leftSource");
            this.rightSource = Objects.requireNonNull(rightSource, "rightSource");
            this.leftJoinExpression = Objects.requireNonNull(leftJoinExpression, "leftJoinExpression");
            this.rightJoinExpression = Objects.requireNonNull(rightJoinExpression, "rightJoinExpression");
            this.type = Objects.requireNonNull(type, "type");
            this.flippedJoinCondition = flippedJoinCondition;
            this.withinExpression = Objects.requireNonNull(withinExpression, "withinExpression");
        }

        public AliasedDataSource getLeftSource() {
            return this.leftSource;
        }

        public AliasedDataSource getRightSource() {
            return this.rightSource;
        }

        public Expression getLeftJoinExpression() {
            return this.leftJoinExpression;
        }

        public Expression getRightJoinExpression() {
            return this.rightJoinExpression;
        }

        public Expression getFlippedLeftJoinExpression() {
            return this.flippedJoinCondition ? this.rightJoinExpression : this.leftJoinExpression;
        }

        public Expression getFlippedRightJoinExpression() {
            return this.flippedJoinCondition ? this.leftJoinExpression : this.rightJoinExpression;
        }

        public JoinNode.JoinType getType() {
            return this.type;
        }

        public boolean hasFlippedJoinCondition() {
            return this.flippedJoinCondition;
        }

        public Optional<WithinExpression> getWithinExpression() {
            return this.withinExpression;
        }

        public JoinInfo flip() {
            return new JoinInfo(this.rightSource, this.rightJoinExpression, this.leftSource, this.leftJoinExpression, this.type, true, this.withinExpression);
        }
    }

    @Immutable
    public static final class AliasedDataSource {
        private final SourceName alias;
        private final DataSource dataSource;

        public AliasedDataSource(SourceName alias, DataSource dataSource) {
            this.alias = Objects.requireNonNull(alias, "alias");
            this.dataSource = Objects.requireNonNull(dataSource, "dataSource");
        }

        public SourceName getAlias() {
            return this.alias;
        }

        public DataSource getDataSource() {
            return this.dataSource;
        }
    }

    @Immutable
    public static final class Into {
        private final SourceName name;
        private final Optional<KsqlTopic> existingTopic;
        private final Optional<NewTopic> newTopic;

        public static Into existingSink(SourceName name, KsqlTopic topic) {
            return new Into(name, Optional.of(topic), Optional.empty());
        }

        public static Into newSink(SourceName name, String topicName, Optional<WindowInfo> windowInfo, FormatInfo keyFormat, FormatInfo valueFormat) {
            NewTopic newTopic = new NewTopic(topicName, windowInfo, keyFormat, valueFormat);
            return new Into(name, Optional.empty(), Optional.of(newTopic));
        }

        private Into(SourceName name, Optional<KsqlTopic> existingTopic, Optional<NewTopic> newTopic) {
            this.name = Objects.requireNonNull(name, "name");
            this.existingTopic = Objects.requireNonNull(existingTopic, "existingTopic");
            this.newTopic = Objects.requireNonNull(newTopic, "newTopic");
        }

        public SourceName getName() {
            return this.name;
        }

        public boolean isCreate() {
            return !this.existingTopic.isPresent();
        }

        public Optional<KsqlTopic> getExistingTopic() {
            return this.existingTopic;
        }

        public Optional<NewTopic> getNewTopic() {
            return this.newTopic;
        }

        @Immutable
        public static class NewTopic {
            private final String topicName;
            private final Optional<WindowInfo> windowInfo;
            private final FormatInfo keyFormat;
            private final FormatInfo valueFormat;

            public NewTopic(String topicName, Optional<WindowInfo> windowInfo, FormatInfo keyFormat, FormatInfo valueFormat) {
                this.topicName = Objects.requireNonNull(topicName, "topicName");
                this.windowInfo = Objects.requireNonNull(windowInfo, "windowInfo");
                this.keyFormat = Objects.requireNonNull(keyFormat, "keyFormat");
                this.valueFormat = Objects.requireNonNull(valueFormat, "valueFormat");
            }

            public String getTopicName() {
                return this.topicName;
            }

            public Optional<WindowInfo> getWindowInfo() {
                return this.windowInfo;
            }

            public FormatInfo getKeyFormat() {
                return this.keyFormat;
            }

            public FormatInfo getValueFormat() {
                return this.valueFormat;
            }
        }
    }
}

