/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.analyzer;

import io.confluent.ksql.analyzer.AggregateAnalysisResult;
import io.confluent.ksql.execution.expression.tree.ColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class MutableAggregateAnalysis
implements AggregateAnalysisResult {
    private final List<ColumnReferenceExp> requiredColumns = new ArrayList<ColumnReferenceExp>();
    private final List<Expression> finalSelectExpressions = new ArrayList<Expression>();
    private final List<Expression> aggregateFunctionArguments = new ArrayList<Expression>();
    private final List<FunctionCall> aggFunctions = new ArrayList<FunctionCall>();
    private Optional<Expression> havingExpression = Optional.empty();

    void addAggregateFunctionArgument(Expression argument) {
        this.aggregateFunctionArguments.add(argument);
    }

    @Override
    public List<Expression> getAggregateFunctionArguments() {
        return Collections.unmodifiableList(this.aggregateFunctionArguments);
    }

    void addRequiredColumn(ColumnReferenceExp node) {
        if (!this.requiredColumns.contains(node)) {
            this.requiredColumns.add(node);
        }
    }

    @Override
    public List<ColumnReferenceExp> getRequiredColumns() {
        return Collections.unmodifiableList(this.requiredColumns);
    }

    void addAggFunction(FunctionCall functionCall) {
        this.aggFunctions.add(functionCall);
    }

    @Override
    public List<FunctionCall> getAggregateFunctions() {
        return Collections.unmodifiableList(this.aggFunctions);
    }

    void addFinalSelectExpression(Expression expression) {
        this.finalSelectExpressions.add(expression);
    }

    @Override
    public List<Expression> getFinalSelectExpressions() {
        return Collections.unmodifiableList(this.finalSelectExpressions);
    }

    void setHavingExpression(Expression havingExpression) {
        this.havingExpression = Optional.of(havingExpression);
    }

    @Override
    public Optional<Expression> getHavingExpression() {
        return this.havingExpression;
    }
}

