/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.analyzer;

import io.confluent.ksql.analyzer.Analysis;
import io.confluent.ksql.analyzer.ImmutableAnalysis;
import io.confluent.ksql.analyzer.SourceSchemas;
import io.confluent.ksql.engine.rewrite.ExpressionTreeRewriter;
import io.confluent.ksql.execution.expression.tree.ColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.execution.windows.HoppingWindowExpression;
import io.confluent.ksql.execution.windows.KsqlWindowExpression;
import io.confluent.ksql.execution.windows.SessionWindowExpression;
import io.confluent.ksql.execution.windows.TumblingWindowExpression;
import io.confluent.ksql.execution.windows.WindowTimeClause;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.parser.OutputRefinement;
import io.confluent.ksql.parser.properties.with.CreateSourceAsProperties;
import io.confluent.ksql.parser.tree.GroupBy;
import io.confluent.ksql.parser.tree.PartitionBy;
import io.confluent.ksql.parser.tree.SelectItem;
import io.confluent.ksql.parser.tree.SingleColumn;
import io.confluent.ksql.parser.tree.StructAll;
import io.confluent.ksql.parser.tree.WindowExpression;
import io.confluent.ksql.serde.RefinementInfo;
import io.confluent.ksql.util.KsqlException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class RewrittenAnalysis
implements ImmutableAnalysis {
    private final ImmutableAnalysis original;
    private final BiFunction<Expression, ExpressionTreeRewriter.Context<Void>, Optional<Expression>> rewriter;
    static final WindowTimeClause zeroGracePeriod = new WindowTimeClause(0L, TimeUnit.MILLISECONDS);

    public RewrittenAnalysis(ImmutableAnalysis original, BiFunction<Expression, ExpressionTreeRewriter.Context<Void>, Optional<Expression>> rewriter) {
        this.original = Objects.requireNonNull(original, "original");
        this.rewriter = Objects.requireNonNull(rewriter, "rewriter");
    }

    public ImmutableAnalysis original() {
        return this.original;
    }

    @Override
    public List<FunctionCall> getTableFunctions() {
        return this.rewriteList(this.original.getTableFunctions());
    }

    @Override
    public List<FunctionCall> getAggregateFunctions() {
        return this.rewriteList(this.original.getAggregateFunctions());
    }

    @Override
    public List<SelectItem> getSelectItems() {
        return this.original.getSelectItems().stream().map(si -> {
            if (si instanceof SingleColumn) {
                SingleColumn singleColumn = (SingleColumn)si;
                return new SingleColumn(singleColumn.getLocation(), this.rewrite(singleColumn.getExpression()), singleColumn.getAlias());
            }
            if (si instanceof StructAll) {
                StructAll structAll = (StructAll)si;
                return new StructAll(structAll.getLocation(), this.rewrite(structAll.getBaseStruct()));
            }
            return si;
        }).collect(Collectors.toList());
    }

    @Override
    public Optional<Expression> getWhereExpression() {
        return this.rewriteOptional(this.original.getWhereExpression());
    }

    @Override
    public Optional<Analysis.Into> getInto() {
        return this.original.getInto();
    }

    @Override
    public Set<ColumnName> getSelectColumnNames() {
        return this.original.getSelectColumnNames().stream().map(this::rewrite).collect(Collectors.toSet());
    }

    @Override
    public Optional<Expression> getHavingExpression() {
        return this.rewriteOptional(this.original.getHavingExpression());
    }

    @Override
    public Optional<WindowExpression> getWindowExpression() {
        HoppingWindowExpression ksqlWindowNew;
        Optional<WindowExpression> windowExpression = this.original.getWindowExpression();
        Optional<RefinementInfo> refinementInfo = this.original.getRefinementInfo();
        if (!windowExpression.isPresent() || !refinementInfo.isPresent() || refinementInfo.get().getOutputRefinement() == OutputRefinement.CHANGES) {
            return this.original.getWindowExpression();
        }
        Optional gracePeriod = !windowExpression.get().getKsqlWindowExpression().getGracePeriod().isPresent() ? Optional.of(zeroGracePeriod) : windowExpression.get().getKsqlWindowExpression().getGracePeriod();
        WindowExpression window = this.original.getWindowExpression().get();
        KsqlWindowExpression ksqlWindowOld = window.getKsqlWindowExpression();
        Optional location = ksqlWindowOld.getLocation();
        Optional retention = ksqlWindowOld.getRetention();
        if (ksqlWindowOld instanceof HoppingWindowExpression) {
            ksqlWindowNew = new HoppingWindowExpression(location, ((HoppingWindowExpression)ksqlWindowOld).getSize(), ((HoppingWindowExpression)ksqlWindowOld).getAdvanceBy(), retention, gracePeriod, Optional.of(OutputRefinement.FINAL));
        } else if (ksqlWindowOld instanceof TumblingWindowExpression) {
            ksqlWindowNew = new TumblingWindowExpression(location, ((TumblingWindowExpression)ksqlWindowOld).getSize(), retention, gracePeriod, Optional.of(OutputRefinement.FINAL));
        } else if (ksqlWindowOld instanceof SessionWindowExpression) {
            ksqlWindowNew = new SessionWindowExpression(location, ((SessionWindowExpression)ksqlWindowOld).getGap(), retention, gracePeriod, Optional.of(OutputRefinement.FINAL));
        } else {
            throw new KsqlException("WINDOW type must be HOPPING, TUMBLING, or SESSION");
        }
        return Optional.of(new WindowExpression(this.original.getWindowExpression().get().getWindowName(), (KsqlWindowExpression)ksqlWindowNew));
    }

    @Override
    public ColumnReferenceExp getDefaultArgument() {
        return this.rewrite(this.original.getDefaultArgument());
    }

    @Override
    public Optional<PartitionBy> getPartitionBy() {
        return this.original.getPartitionBy().map(partitionBy -> new PartitionBy(partitionBy.getLocation(), this.rewriteList(partitionBy.getExpressions())));
    }

    @Override
    public Optional<GroupBy> getGroupBy() {
        return this.original.getGroupBy().map(groupBy -> new GroupBy(groupBy.getLocation(), this.rewriteList(groupBy.getGroupingExpressions())));
    }

    @Override
    public Optional<RefinementInfo> getRefinementInfo() {
        return this.original.getRefinementInfo();
    }

    @Override
    public OptionalInt getLimitClause() {
        return this.original.getLimitClause();
    }

    @Override
    public List<Analysis.JoinInfo> getJoin() {
        return this.original.getJoin();
    }

    @Override
    public boolean isJoin() {
        return this.original.isJoin();
    }

    @Override
    public List<Analysis.AliasedDataSource> getAllDataSources() {
        return this.original.getAllDataSources();
    }

    @Override
    public CreateSourceAsProperties getProperties() {
        return this.original.getProperties();
    }

    @Override
    public SourceSchemas getFromSourceSchemas(boolean postAggregate) {
        return this.original.getFromSourceSchemas(postAggregate);
    }

    @Override
    public Analysis.AliasedDataSource getFrom() {
        return this.original.getFrom();
    }

    private <T extends Expression> Optional<T> rewriteOptional(Optional<T> expression) {
        return expression.map(this::rewrite);
    }

    @Override
    public boolean getOrReplace() {
        return this.original.getOrReplace();
    }

    private <T extends Expression> List<T> rewriteList(List<T> expressions) {
        return expressions.stream().map(this::rewrite).collect(Collectors.toList());
    }

    private <T extends Expression> T rewrite(T expression) {
        return ExpressionTreeRewriter.rewriteWith(this.rewriter, expression);
    }

    private ColumnName rewrite(ColumnName name) {
        UnqualifiedColumnReferenceExp colRef = new UnqualifiedColumnReferenceExp(name);
        return ExpressionTreeRewriter.rewriteWith(this.rewriter, colRef).getColumnName();
    }
}

