/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.analyzer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.SystemColumns;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class SourceSchemas {
    private final ImmutableMap<SourceName, LogicalSchema> sourceSchemas;

    SourceSchemas(Map<SourceName, LogicalSchema> sourceSchemas) {
        this.sourceSchemas = ImmutableMap.copyOf(Objects.requireNonNull(sourceSchemas, "sourceSchemas"));
        if (sourceSchemas.isEmpty()) {
            throw new IllegalArgumentException("Must supply at least one schema");
        }
    }

    public boolean isJoin() {
        return this.sourceSchemas.size() > 1;
    }

    public Set<SourceName> sourcesWithField(Optional<SourceName> source, ColumnName target) {
        if (!source.isPresent()) {
            return this.sourceSchemas.entrySet().stream().filter(e -> ((LogicalSchema)e.getValue()).findColumn(target).isPresent()).map(Map.Entry::getKey).collect(Collectors.toSet());
        }
        SourceName sourceName = source.get();
        LogicalSchema sourceSchema = (LogicalSchema)this.sourceSchemas.get((Object)sourceName);
        if (sourceSchema == null) {
            return ImmutableSet.of();
        }
        return sourceSchema.findColumn(target).isPresent() ? ImmutableSet.of((Object)sourceName) : ImmutableSet.of();
    }

    boolean matchesNonValueField(Optional<SourceName> source, ColumnName column) {
        if (!source.isPresent()) {
            return this.sourceSchemas.values().stream().anyMatch(schema -> SystemColumns.isPseudoColumn((ColumnName)column) || schema.isKeyColumn(column));
        }
        SourceName sourceName = source.get();
        LogicalSchema sourceSchema = (LogicalSchema)this.sourceSchemas.get((Object)sourceName);
        if (sourceSchema == null) {
            throw new IllegalArgumentException("Unknown source: " + sourceName);
        }
        return sourceSchema.isKeyColumn(column) || SystemColumns.isPseudoColumn((ColumnName)column);
    }
}

