/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.connect.supported;

import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.connect.Connector;
import io.confluent.ksql.connect.supported.JdbcSource;
import io.confluent.ksql.connect.supported.SupportedConnector;
import io.confluent.ksql.rest.entity.ConnectorInfo;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum Connectors implements SupportedConnector
{
    JDBC("io.confluent.connect.jdbc.JdbcSourceConnector", new JdbcSource());

    public static final String CONNECTOR_CLASS = "connector.class";
    private static final Map<String, SupportedConnector> CONNECTORS;
    private final String connectorClass;
    private final SupportedConnector supportedConnector;

    private Connectors(String connectorClass, SupportedConnector supportedConnector) {
        this.connectorClass = Objects.requireNonNull(connectorClass, "connectorClass");
        this.supportedConnector = Objects.requireNonNull(supportedConnector, "supportedConnector");
    }

    public static Optional<Connector> from(ConnectorInfo info) {
        SupportedConnector connector = CONNECTORS.get(info.config().get(CONNECTOR_CLASS));
        return connector == null ? Optional.empty() : connector.fromConnectInfo(info);
    }

    public static Map<String, String> resolve(Map<String, String> configs) {
        SupportedConnector connector = CONNECTORS.get(configs.get(CONNECTOR_CLASS));
        return new HashMap<String, String>(connector == null ? configs : connector.resolveConfigs(configs));
    }

    @Override
    public Optional<Connector> fromConnectInfo(ConnectorInfo info) {
        return this.supportedConnector.fromConnectInfo(info);
    }

    @Override
    public Map<String, String> resolveConfigs(Map<String, String> configs) {
        return this.supportedConnector.resolveConfigs(configs);
    }

    public String getConnectorClass() {
        return this.connectorClass;
    }

    static {
        CONNECTORS = ImmutableMap.copyOf(EnumSet.allOf(Connectors.class).stream().collect(Collectors.toMap(Connectors::getConnectorClass, Function.identity())));
    }
}

