/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.ddl.commands;

import io.confluent.ksql.execution.ddl.commands.AlterSourceCommand;
import io.confluent.ksql.execution.ddl.commands.CreateSourceCommand;
import io.confluent.ksql.execution.ddl.commands.CreateStreamCommand;
import io.confluent.ksql.execution.ddl.commands.CreateTableCommand;
import io.confluent.ksql.execution.ddl.commands.DdlCommand;
import io.confluent.ksql.execution.ddl.commands.DdlCommandResult;
import io.confluent.ksql.execution.ddl.commands.DropSourceCommand;
import io.confluent.ksql.execution.ddl.commands.DropTypeCommand;
import io.confluent.ksql.execution.ddl.commands.KsqlTopic;
import io.confluent.ksql.execution.ddl.commands.RegisterTypeCommand;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.metastore.MutableMetaStore;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.metastore.model.KsqlStream;
import io.confluent.ksql.metastore.model.KsqlTable;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.KeyFormat;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.serde.ValueFormat;
import io.confluent.ksql.util.DuplicateColumnException;
import io.confluent.ksql.util.KsqlException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class DdlCommandExec {
    private final MutableMetaStore metaStore;

    public DdlCommandExec(MutableMetaStore metaStore) {
        this.metaStore = Objects.requireNonNull(metaStore, "metaStore");
    }

    public DdlCommandResult execute(String sql, DdlCommand ddlCommand, boolean withQuery, Set<SourceName> withQuerySources) {
        return this.execute(sql, ddlCommand, withQuery, withQuerySources, false);
    }

    public DdlCommandResult execute(String sql, DdlCommand ddlCommand, boolean withQuery, Set<SourceName> withQuerySources, boolean restoreInProgress) {
        return new Executor(sql, withQuery, withQuerySources, restoreInProgress).execute(ddlCommand);
    }

    private static KsqlTopic getKsqlTopic(CreateSourceCommand cs) {
        Formats formats = cs.getFormats();
        return new KsqlTopic(cs.getTopicName(), KeyFormat.of((FormatInfo)formats.getKeyFormat(), (SerdeFeatures)formats.getKeyFeatures(), (Optional)cs.getWindowInfo()), ValueFormat.of((FormatInfo)formats.getValueFormat(), (SerdeFeatures)formats.getValueFeatures()));
    }

    private final class Executor
    implements io.confluent.ksql.execution.ddl.commands.Executor {
        private final String sql;
        private final boolean withQuery;
        private final Set<SourceName> withQuerySources;
        private final boolean restoreInProgress;

        private Executor(String sql, boolean withQuery, Set<SourceName> withQuerySources, boolean restoreInProgress) {
            this.sql = Objects.requireNonNull(sql, "sql");
            this.withQuery = withQuery;
            this.withQuerySources = Objects.requireNonNull(withQuerySources, "withQuerySources");
            this.restoreInProgress = restoreInProgress;
        }

        public DdlCommandResult executeCreateStream(CreateStreamCommand createStream) {
            SourceName sourceName = createStream.getSourceName();
            DataSource dataSource = DdlCommandExec.this.metaStore.getSource(sourceName);
            if (dataSource != null && !createStream.isOrReplace().booleanValue()) {
                String sourceType = dataSource.getDataSourceType().getKsqlType();
                return new DdlCommandResult(true, String.format("Cannot add stream %s: A %s with the same name already exists.", sourceName, sourceType.toLowerCase()));
            }
            KsqlStream ksqlStream = new KsqlStream(this.sql, createStream.getSourceName(), createStream.getSchema(), createStream.getTimestampColumn(), this.withQuery, DdlCommandExec.getKsqlTopic((CreateSourceCommand)createStream), createStream.getIsSource().booleanValue());
            DdlCommandExec.this.metaStore.putSource((DataSource)ksqlStream, createStream.isOrReplace().booleanValue());
            DdlCommandExec.this.metaStore.addSourceReferences(ksqlStream.getName(), this.withQuerySources);
            return new DdlCommandResult(true, "Stream created");
        }

        public DdlCommandResult executeCreateTable(CreateTableCommand createTable) {
            SourceName sourceName = createTable.getSourceName();
            DataSource dataSource = DdlCommandExec.this.metaStore.getSource(sourceName);
            if (dataSource != null && !createTable.isOrReplace().booleanValue()) {
                String sourceType = dataSource.getDataSourceType().getKsqlType();
                return new DdlCommandResult(true, String.format("Cannot add table %s: A %s with the same name already exists.", sourceName, sourceType.toLowerCase()));
            }
            KsqlTable ksqlTable = new KsqlTable(this.sql, createTable.getSourceName(), createTable.getSchema(), createTable.getTimestampColumn(), this.withQuery, DdlCommandExec.getKsqlTopic((CreateSourceCommand)createTable), createTable.getIsSource().booleanValue());
            DdlCommandExec.this.metaStore.putSource((DataSource)ksqlTable, createTable.isOrReplace().booleanValue());
            if (!createTable.getIsSource().booleanValue()) {
                DdlCommandExec.this.metaStore.addSourceReferences(ksqlTable.getName(), this.withQuerySources);
            }
            return new DdlCommandResult(true, "Table created");
        }

        public DdlCommandResult executeDropSource(DropSourceCommand dropSource) {
            SourceName sourceName = dropSource.getSourceName();
            DataSource dataSource = DdlCommandExec.this.metaStore.getSource(sourceName);
            if (dataSource == null) {
                return new DdlCommandResult(true, "Source " + sourceName + " does not exist.");
            }
            DdlCommandExec.this.metaStore.deleteSource(sourceName, this.restoreInProgress);
            return new DdlCommandResult(true, "Source " + sourceName + " (topic: " + dataSource.getKafkaTopicName() + ") was dropped.");
        }

        public DdlCommandResult executeRegisterType(RegisterTypeCommand registerType) {
            String name = registerType.getTypeName();
            SqlType type = registerType.getType();
            boolean wasRegistered = DdlCommandExec.this.metaStore.registerType(name, type);
            return wasRegistered ? new DdlCommandResult(true, "Registered custom type with name '" + name + "' and SQL type " + type) : new DdlCommandResult(true, name + " is already registered with type " + DdlCommandExec.this.metaStore.resolveType(name).get());
        }

        public DdlCommandResult executeDropType(DropTypeCommand dropType) {
            String typeName = dropType.getTypeName();
            boolean wasDeleted = DdlCommandExec.this.metaStore.deleteType(typeName);
            return wasDeleted ? new DdlCommandResult(true, "Dropped type '" + typeName + "'") : new DdlCommandResult(true, "Type '" + typeName + "' does not exist");
        }

        public DdlCommandResult executeAlterSource(AlterSourceCommand alterSource) {
            LogicalSchema newSchema;
            DataSource dataSource = DdlCommandExec.this.metaStore.getSource(alterSource.getSourceName());
            if (dataSource == null) {
                throw new KsqlException("Source " + alterSource.getSourceName().text() + " does not exist.");
            }
            if (!dataSource.getDataSourceType().getKsqlType().equals(alterSource.getKsqlType())) {
                throw new KsqlException(String.format("Incompatible data source type is %s, but statement was ALTER %s", dataSource.getDataSourceType().getKsqlType(), alterSource.getKsqlType()));
            }
            if (dataSource.isCasTarget()) {
                throw new KsqlException(String.format("ALTER command is not supported for CREATE ... AS statements.", new Object[0]));
            }
            try {
                newSchema = dataSource.getSchema().asBuilder().valueColumns((Iterable)alterSource.getNewColumns()).build();
            }
            catch (DuplicateColumnException e) {
                throw new KsqlException("Cannot add column " + e.getColumn().name() + " to schema. A column with the same name already exists.");
            }
            DdlCommandExec.this.metaStore.putSource(dataSource.with(this.sql, newSchema), true);
            return new DdlCommandResult(true, String.format("%s %s altered.", dataSource.getDataSourceType() == DataSource.DataSourceType.KSTREAM ? "Stream" : "Table", dataSource.getName().text()));
        }
    }
}

