/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.engine;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.ksql.engine.KsqlPlan;
import io.confluent.ksql.engine.QueryPlan;
import io.confluent.ksql.execution.ddl.commands.CreateTableCommand;
import io.confluent.ksql.execution.ddl.commands.DdlCommand;
import io.confluent.ksql.util.KsqlConstants;
import java.util.Objects;
import java.util.Optional;

final class KsqlPlanV1
implements KsqlPlan {
    private final String statementText;
    private final Optional<DdlCommand> ddlCommand;
    private final Optional<QueryPlan> queryPlan;

    KsqlPlanV1(@JsonProperty(value="statementText", required=true) String maskedStatement, @JsonProperty(value="ddlCommand") Optional<DdlCommand> ddlCommand, @JsonProperty(value="queryPlan") Optional<QueryPlan> queryPlan) {
        this.statementText = Objects.requireNonNull(maskedStatement, "statementText");
        this.ddlCommand = Objects.requireNonNull(ddlCommand, "ddlCommand");
        this.queryPlan = Objects.requireNonNull(queryPlan, "queryPlan");
        if (!ddlCommand.isPresent() && !queryPlan.isPresent()) {
            throw new IllegalArgumentException("Plan requires at least a DDL command or query plan.");
        }
    }

    @Override
    public Optional<DdlCommand> getDdlCommand() {
        return this.ddlCommand;
    }

    @Override
    public Optional<QueryPlan> getQueryPlan() {
        return this.queryPlan;
    }

    @Override
    public String getStatementText() {
        return this.statementText;
    }

    @Override
    public KsqlPlan withoutQuery() {
        return new KsqlPlanV1(this.statementText, this.ddlCommand, Optional.empty());
    }

    @Override
    public Optional<KsqlConstants.PersistentQueryType> getPersistentQueryType() {
        if (!this.queryPlan.isPresent()) {
            return Optional.empty();
        }
        if (this.ddlCommand.isPresent()) {
            if (this.ddlCommand.get() instanceof CreateTableCommand && ((CreateTableCommand)this.ddlCommand.get()).getIsSource().booleanValue()) {
                return Optional.of(KsqlConstants.PersistentQueryType.CREATE_SOURCE);
            }
            return Optional.of(KsqlConstants.PersistentQueryType.CREATE_AS);
        }
        return Optional.of(KsqlConstants.PersistentQueryType.INSERT);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KsqlPlanV1 that = (KsqlPlanV1)o;
        return Objects.equals(this.ddlCommand, that.ddlCommand) && Objects.equals(this.queryPlan, that.queryPlan);
    }

    public int hashCode() {
        return Objects.hash(this.ddlCommand, this.queryPlan);
    }
}

