/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.pull.operators;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.execution.common.operators.AbstractPhysicalOperator;
import io.confluent.ksql.execution.common.operators.UnaryPhysicalOperator;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.planner.plan.QueryLimitNode;
import java.util.List;
import java.util.Objects;

public class LimitOperator
extends AbstractPhysicalOperator
implements UnaryPhysicalOperator {
    private AbstractPhysicalOperator child;
    private final QueryLimitNode logicalNode;
    private final int limit;
    private int rowsReturned;

    public LimitOperator(QueryLimitNode logicalNode) {
        this(logicalNode, logicalNode.getLimit());
    }

    @VisibleForTesting
    LimitOperator(QueryLimitNode logicalNode, int limit) {
        this.logicalNode = Objects.requireNonNull(logicalNode, "logicalNode");
        this.limit = limit;
        this.rowsReturned = 0;
    }

    @Override
    public void open() {
        this.child.open();
    }

    @Override
    public Object next() {
        if (this.rowsReturned >= this.limit) {
            return null;
        }
        Object row = this.child.next();
        if (row == null) {
            return null;
        }
        ++this.rowsReturned;
        return row;
    }

    @Override
    public void close() {
        this.child.close();
    }

    @Override
    public PlanNode getLogicalNode() {
        return this.logicalNode;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public void addChild(AbstractPhysicalOperator child) {
        if (this.child != null) {
            throw new UnsupportedOperationException("The limit operator already has a child.");
        }
        Objects.requireNonNull(child, "child");
        this.child = child;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public AbstractPhysicalOperator getChild() {
        return this.child;
    }

    @Override
    public AbstractPhysicalOperator getChild(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<AbstractPhysicalOperator> getChildren() {
        throw new UnsupportedOperationException();
    }
}

