/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.scalablepush;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.common.QueryRow;
import io.confluent.ksql.execution.scalablepush.PushPhysicalPlanManager;
import io.confluent.ksql.execution.scalablepush.PushRoutingOptions;
import io.confluent.ksql.execution.scalablepush.ScalablePushRegistry;
import io.confluent.ksql.execution.scalablepush.locator.PushLocator;
import io.confluent.ksql.internal.ScalablePushQueryMetrics;
import io.confluent.ksql.logging.query.QueryLogger;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.query.TransientQueryQueue;
import io.confluent.ksql.reactive.BaseSubscriber;
import io.confluent.ksql.reactive.BufferedPublisher;
import io.confluent.ksql.rest.client.RestResponse;
import io.confluent.ksql.rest.entity.KsqlErrorMessage;
import io.confluent.ksql.rest.entity.PushContinuationToken;
import io.confluent.ksql.rest.entity.StreamedRow;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.util.KeyValue;
import io.confluent.ksql.util.KeyValueMetadata;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.OffsetVector;
import io.confluent.ksql.util.PushOffsetRange;
import io.confluent.ksql.util.PushOffsetVector;
import io.confluent.ksql.util.RowMetadata;
import io.confluent.ksql.util.VertxUtils;
import io.vertx.core.Context;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushRouting
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(PushRouting.class);
    private static final long CLUSTER_CHECK_INTERVAL_MS = 1000L;
    private static final long HOST_CACHE_EXPIRATION_MS = 1000L;
    private final Function<ScalablePushRegistry, Set<PushLocator.KsqlNode>> registryToNodes;
    private final long clusterCheckInterval;
    private final boolean backgroundRetries;

    public PushRouting() {
        this(PushRouting.createLoadingCache(), 1000L, true);
    }

    @VisibleForTesting
    public PushRouting(Function<ScalablePushRegistry, Set<PushLocator.KsqlNode>> registryToNodes, long clusterCheckInterval, boolean backgroundRetries) {
        this.registryToNodes = registryToNodes;
        this.clusterCheckInterval = clusterCheckInterval;
        this.backgroundRetries = backgroundRetries;
    }

    @Override
    public void close() {
    }

    public CompletableFuture<PushConnectionsHandle> handlePushQuery(ServiceContext serviceContext, PushPhysicalPlanManager pushPhysicalPlanManager, ConfiguredStatement<Query> statement, PushRoutingOptions pushRoutingOptions, LogicalSchema outputSchema, TransientQueryQueue transientQueryQueue, Optional<ScalablePushQueryMetrics> scalablePushQueryMetrics, Optional<PushOffsetRange> offsetRange) {
        Set<PushLocator.KsqlNode> hosts = this.getInitialHosts(pushPhysicalPlanManager, statement, pushRoutingOptions);
        String thisHostName = hosts.stream().filter(PushLocator.KsqlNode::isLocal).map(node -> node.location().toString()).findFirst().orElse("unknown");
        PushConnectionsHandle pushConnectionsHandle = new PushConnectionsHandle();
        pushConnectionsHandle.onCompletionOrException((v, t) -> pushPhysicalPlanManager.getScalablePushRegistry().cleanupCatchupConsumer(pushPhysicalPlanManager.getCatchupConsumerGroupId()));
        Set<PushLocator.KsqlNode> catchupHosts = Collections.emptySet();
        if (offsetRange.isPresent()) {
            pushConnectionsHandle.getOffsetsTracker().updateFromToken((OffsetVector)offsetRange.get().getEndOffsets());
            if (!pushRoutingOptions.getHasBeenForwarded()) {
                catchupHosts = hosts;
            }
        }
        CompletableFuture<PushConnectionsHandle> result = this.connectToHosts(serviceContext, pushPhysicalPlanManager, statement, hosts, outputSchema, transientQueryQueue, pushConnectionsHandle, false, scalablePushQueryMetrics, catchupHosts, pushRoutingOptions, thisHostName);
        if (this.backgroundRetries && !pushRoutingOptions.getHasBeenForwarded()) {
            this.checkForNewHostsOnContext(serviceContext, pushPhysicalPlanManager, statement, hosts, outputSchema, transientQueryQueue, pushConnectionsHandle, scalablePushQueryMetrics, pushRoutingOptions, thisHostName);
        }
        return result;
    }

    public void preparePushQuery(PushPhysicalPlanManager pushPhysicalPlanManager, ConfiguredStatement<Query> statement, PushRoutingOptions pushRoutingOptions) {
        this.getInitialHosts(pushPhysicalPlanManager, statement, pushRoutingOptions);
    }

    private Set<PushLocator.KsqlNode> getInitialHosts(PushPhysicalPlanManager pushPhysicalPlanManager, ConfiguredStatement<Query> statement, PushRoutingOptions pushRoutingOptions) {
        Set<PushLocator.KsqlNode> hosts = this.registryToNodes.apply(pushPhysicalPlanManager.getScalablePushRegistry()).stream().filter(node -> !pushRoutingOptions.getHasBeenForwarded() || node.isLocal()).collect(Collectors.toSet());
        if (hosts.isEmpty()) {
            LOG.error("Unable to execute push query: {}. No nodes executing persistent queries", (Object)statement.getMaskedStatementText());
            throw new KsqlException(String.format("Unable to execute push query. No nodes executing persistent queries %s", statement.getMaskedStatementText()));
        }
        return hosts;
    }

    private CompletableFuture<PushConnectionsHandle> connectToHosts(ServiceContext serviceContext, PushPhysicalPlanManager pushPhysicalPlanManager, ConfiguredStatement<Query> statement, Collection<PushLocator.KsqlNode> hosts, LogicalSchema outputSchema, TransientQueryQueue transientQueryQueue, PushConnectionsHandle pushConnectionsHandle, boolean dynamicallyAddedNode, Optional<ScalablePushQueryMetrics> scalablePushQueryMetrics, Set<PushLocator.KsqlNode> catchupHosts, PushRoutingOptions pushRoutingOptions, String thisHostName) {
        LinkedHashMap<PushLocator.KsqlNode, CompletableFuture<RoutingResult>> futureMap = new LinkedHashMap<PushLocator.KsqlNode, CompletableFuture<RoutingResult>>();
        for (PushLocator.KsqlNode node : hosts) {
            pushConnectionsHandle.add(node, new RoutingResult(RoutingResultStatus.IN_PROGRESS, () -> {}));
            CompletableFuture<Void> callback = new CompletableFuture<Void>();
            callback.handle((v, t) -> {
                if (t == null) {
                    pushConnectionsHandle.get(node).ifPresent(result -> {
                        result.close();
                        result.updateStatus(RoutingResultStatus.COMPLETE);
                    });
                    LOG.info("Host {} completed request {}.", (Object)node, (Object)pushPhysicalPlanManager.getQueryId());
                } else if (t instanceof GapFoundException) {
                    pushConnectionsHandle.get(node).ifPresent(result -> {
                        result.close();
                        result.updateStatus(RoutingResultStatus.OFFSET_GAP_FOUND);
                    });
                } else {
                    pushConnectionsHandle.completeExceptionally((Throwable)t);
                }
                return null;
            });
            futureMap.put(node, PushRouting.executeOrRouteQuery(node, statement, serviceContext, pushPhysicalPlanManager, outputSchema, transientQueryQueue, callback, scalablePushQueryMetrics, pushConnectionsHandle.getOffsetsTracker(), catchupHosts.contains(node), pushRoutingOptions, thisHostName));
        }
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(futureMap.values().toArray(new CompletableFuture[0])).thenApply(v -> {
            for (PushLocator.KsqlNode node : hosts) {
                CompletableFuture future = (CompletableFuture)futureMap.get(node);
                RoutingResult routingResult = (RoutingResult)future.join();
                pushConnectionsHandle.add(node, routingResult);
            }
            return pushConnectionsHandle;
        })).exceptionally(t -> {
            PushLocator.KsqlNode node = futureMap.entrySet().stream().filter(e -> ((CompletableFuture)e.getValue()).isCompletedExceptionally()).map(Map.Entry::getKey).findFirst().orElse(null);
            for (PushLocator.KsqlNode n : hosts) {
                CompletableFuture future = (CompletableFuture)futureMap.get(n);
                if (future.isCompletedExceptionally()) {
                    pushConnectionsHandle.get(n).ifPresent(result -> result.updateStatus(RoutingResultStatus.FAILED));
                    continue;
                }
                RoutingResult routingResult = (RoutingResult)future.join();
                pushConnectionsHandle.add(node, routingResult);
            }
            LOG.warn("Error routing query {} id {} to host {} at timestamp {} with exception {}", new Object[]{statement.getMaskedStatementText(), pushPhysicalPlanManager.getQueryId(), node, System.currentTimeMillis(), t.getCause()});
            if (!dynamicallyAddedNode) {
                pushConnectionsHandle.completeExceptionally(new KsqlException(String.format("Unable to execute push query \"%s\". %s", statement.getMaskedStatementText(), t.getCause().getMessage())));
            }
            return pushConnectionsHandle;
        })).exceptionally(t -> {
            LOG.error("Unexpected error handing exception", t);
            return pushConnectionsHandle;
        });
    }

    @VisibleForTesting
    static CompletableFuture<RoutingResult> executeOrRouteQuery(PushLocator.KsqlNode node, ConfiguredStatement<Query> statement, ServiceContext serviceContext, PushPhysicalPlanManager pushPhysicalPlanManager, LogicalSchema outputSchema, TransientQueryQueue transientQueryQueue, CompletableFuture<Void> callback, Optional<ScalablePushQueryMetrics> scalablePushQueryMetrics, OffsetsTracker offsetsTracker, boolean shouldCatchupFromOffsets, PushRoutingOptions pushRoutingOptions, String thisHostName) {
        if (node.isLocal()) {
            LOG.info("Query with id {} executed locally at host {} at timestamp {}.", new Object[]{pushPhysicalPlanManager.getQueryId(), node.location(), System.currentTimeMillis()});
            scalablePushQueryMetrics.ifPresent(metrics -> metrics.recordLocalRequests(1.0));
            AtomicReference closeable = new AtomicReference();
            AtomicReference<Object> publisherRef = new AtomicReference<Object>(null);
            return ((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(null).thenApply(v -> {
                if (pushPhysicalPlanManager.isClosed()) {
                    pushPhysicalPlanManager.reset(Optional.of(offsetsTracker.getOffsetRange()));
                }
                closeable.set(pushPhysicalPlanManager.closeable());
                return pushPhysicalPlanManager.execute();
            })).thenApply(publisher -> {
                publisherRef.set(publisher);
                publisher.subscribe((Subscriber)new LocalQueryStreamSubscriber(publisher.getContext(), transientQueryQueue, callback, node, pushPhysicalPlanManager.getQueryId(), offsetsTracker, pushRoutingOptions, thisHostName));
                return new RoutingResult(RoutingResultStatus.SUCCESS, () -> {
                    ((Runnable)closeable.get()).run();
                    publisher.close();
                });
            })).exceptionally(t -> {
                LOG.error("Error executing query {} locally at node {}", new Object[]{statement.getMaskedStatementText(), node.location(), t.getCause()});
                BufferedPublisher publisher = (BufferedPublisher)publisherRef.get();
                ((Runnable)closeable.get()).run();
                if (publisher != null) {
                    publisher.close();
                }
                throw new KsqlException(String.format("Error executing query locally at node %s: %s", node.location(), t.getMessage()), t);
            });
        }
        QueryLogger.info((Object)String.format("Query routed to host %s at timestamp %d.", node.location(), System.currentTimeMillis()), statement.getMaskedStatementText());
        scalablePushQueryMetrics.ifPresent(metrics -> metrics.recordRemoteRequests(1.0));
        AtomicReference<Object> publisherRef = new AtomicReference<Object>(null);
        CompletableFuture<BufferedPublisher<StreamedRow>> publisherFuture = PushRouting.forwardTo(node, statement, serviceContext, outputSchema, shouldCatchupFromOffsets, offsetsTracker, pushPhysicalPlanManager.getCatchupConsumerGroupId());
        return ((CompletableFuture)publisherFuture.thenApply(publisher -> {
            publisherRef.set(publisher);
            publisher.subscribe((Subscriber)new RemoteStreamSubscriber(publisher.getContext(), transientQueryQueue, callback, node, pushPhysicalPlanManager.getQueryId(), offsetsTracker, pushRoutingOptions, thisHostName));
            return new RoutingResult(RoutingResultStatus.SUCCESS, () -> ((BufferedPublisher)publisher).close());
        })).exceptionally(t -> {
            LOG.error("Error forwarding query {} to node {}", new Object[]{statement.getMaskedStatementText(), node, t.getCause()});
            BufferedPublisher publisher = (BufferedPublisher)publisherRef.get();
            if (publisher != null) {
                publisher.close();
            }
            throw new KsqlException(String.format("Error forwarding query to node %s: %s", node.location(), t.getMessage()), t);
        });
    }

    private static CompletableFuture<BufferedPublisher<StreamedRow>> forwardTo(PushLocator.KsqlNode owner, ConfiguredStatement<Query> statement, ServiceContext serviceContext, LogicalSchema outputSchema, boolean shouldCatchupFromOffsets, OffsetsTracker offsetsTracker, String catchupConsumerGroup) {
        ImmutableMap.Builder requestPropertiesBuilder = ImmutableMap.builder().put((Object)"request.ksql.query.push.skip.forwarding", (Object)true).put((Object)"request.ksql.internal.request", (Object)true);
        if (shouldCatchupFromOffsets) {
            requestPropertiesBuilder.put((Object)"request.ksql.query.push.continuation.token", (Object)offsetsTracker.getSerializedOffsetRange());
            requestPropertiesBuilder.put((Object)"request.ksql.query.push.catchup.consumer.group", (Object)catchupConsumerGroup);
        }
        ImmutableMap requestProperties = requestPropertiesBuilder.build();
        CompletableFuture future = serviceContext.getKsqlClient().makeQueryRequestStreamed(owner.location(), statement.getUnMaskedStatementText(), statement.getSessionConfig().getOverrides(), (Map)requestProperties);
        return future.thenApply(arg_0 -> PushRouting.lambda$forwardTo$20(statement, (Map)requestProperties, arg_0));
    }

    private void checkForNewHostsOnContext(ServiceContext serviceContext, PushPhysicalPlanManager pushPhysicalPlanManager, ConfiguredStatement<Query> statement, Set<PushLocator.KsqlNode> hosts, LogicalSchema outputSchema, TransientQueryQueue transientQueryQueue, PushConnectionsHandle pushConnectionsHandle, Optional<ScalablePushQueryMetrics> scalablePushQueryMetrics, PushRoutingOptions pushRoutingOptions, String thisHostName) {
        pushPhysicalPlanManager.getContext().runOnContext(v -> this.checkForNewHosts(serviceContext, pushPhysicalPlanManager, statement, outputSchema, transientQueryQueue, pushConnectionsHandle, scalablePushQueryMetrics, pushRoutingOptions, thisHostName));
    }

    private void checkForNewHosts(ServiceContext serviceContext, PushPhysicalPlanManager pushPhysicalPlanManager, ConfiguredStatement<Query> statement, LogicalSchema outputSchema, TransientQueryQueue transientQueryQueue, PushConnectionsHandle pushConnectionsHandle, Optional<ScalablePushQueryMetrics> scalablePushQueryMetrics, PushRoutingOptions pushRoutingOptions, String thisHostName) {
        VertxUtils.checkContext((Context)pushPhysicalPlanManager.getContext());
        if (pushConnectionsHandle.isClosed()) {
            return;
        }
        Set<PushLocator.KsqlNode> updatedHosts = this.registryToNodes.apply(pushPhysicalPlanManager.getScalablePushRegistry());
        Set<PushLocator.KsqlNode> hosts = pushConnectionsHandle.getActiveHosts();
        Set<PushLocator.KsqlNode> newHosts = Sets.difference(updatedHosts, hosts).stream().filter(node -> pushConnectionsHandle.get((PushLocator.KsqlNode)node).map(routingResult -> routingResult.getStatus() != RoutingResultStatus.IN_PROGRESS).orElse(true)).collect(Collectors.toSet());
        Sets.SetView removedHosts = Sets.difference(hosts, updatedHosts);
        if (newHosts.size() > 0) {
            LOG.info("Dynamically adding new hosts {} for {}", newHosts, (Object)pushPhysicalPlanManager.getQueryId());
            Set<PushLocator.KsqlNode> catchupHosts = newHosts.stream().filter(node -> pushConnectionsHandle.get((PushLocator.KsqlNode)node).map(routingResult -> routingResult.getStatus() == RoutingResultStatus.OFFSET_GAP_FOUND).orElse(false)).collect(Collectors.toSet());
            this.connectToHosts(serviceContext, pushPhysicalPlanManager, statement, newHosts, outputSchema, transientQueryQueue, pushConnectionsHandle, true, scalablePushQueryMetrics, catchupHosts, pushRoutingOptions, thisHostName);
        }
        if (removedHosts.size() > 0) {
            LOG.info("Dynamically removing hosts {} for {}", (Object)removedHosts, (Object)pushPhysicalPlanManager.getQueryId());
            for (PushLocator.KsqlNode node2 : removedHosts) {
                RoutingResult result = pushConnectionsHandle.remove(node2);
                result.close();
                result.updateStatus(RoutingResultStatus.REMOVED);
            }
        }
        pushPhysicalPlanManager.getContext().owner().setTimer(this.clusterCheckInterval, timerId -> this.checkForNewHosts(serviceContext, pushPhysicalPlanManager, statement, outputSchema, transientQueryQueue, pushConnectionsHandle, scalablePushQueryMetrics, pushRoutingOptions, thisHostName));
    }

    private static Set<PushLocator.KsqlNode> loadCurrentHosts(ScalablePushRegistry scalablePushRegistry) {
        return new HashSet<PushLocator.KsqlNode>(scalablePushRegistry.getLocator().locate());
    }

    private static Function<ScalablePushRegistry, Set<PushLocator.KsqlNode>> createLoadingCache() {
        LoadingCache cache = CacheBuilder.newBuilder().maximumSize(40L).expireAfterWrite(1000L, TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<ScalablePushRegistry, Set<PushLocator.KsqlNode>>(){

            public Set<PushLocator.KsqlNode> load(ScalablePushRegistry scalablePushRegistry) {
                return PushRouting.loadCurrentHosts(scalablePushRegistry);
            }
        });
        return arg_0 -> ((LoadingCache)cache).getUnchecked(arg_0);
    }

    private static /* synthetic */ BufferedPublisher lambda$forwardTo$20(ConfiguredStatement statement, Map requestProperties, RestResponse response) {
        if (response.isErroneous()) {
            throw new KsqlException(String.format("Forwarding pull query request [%s, %s] failed with error %s ", statement.getSessionConfig().getOverrides(), requestProperties, response.getErrorMessage()));
        }
        return (BufferedPublisher)response.getResponse();
    }

    public static class GapFoundException
    extends RuntimeException {
    }

    public static class OffsetsTracker {
        private final PushOffsetVector currentOffsets = new PushOffsetVector();

        public PushOffsetVector getOffsets() {
            return this.currentOffsets;
        }

        public PushOffsetRange getOffsetRange() {
            return new PushOffsetRange(Optional.empty(), this.currentOffsets);
        }

        public String getSerializedOffsetRange() {
            return this.getOffsetRange().serialize();
        }

        public void updateFromToken(OffsetVector update) {
            this.currentOffsets.merge(update);
        }
    }

    public static class PushConnectionsHandle {
        private final Map<PushLocator.KsqlNode, RoutingResult> results = new ConcurrentHashMap<PushLocator.KsqlNode, RoutingResult>();
        private final CompletableFuture<Void> callback;
        private volatile boolean closed = false;
        private final OffsetsTracker offsetsTracker = new OffsetsTracker();

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
        public PushConnectionsHandle() {
            this.callback = new CompletableFuture();
            this.callback.exceptionally(t -> {
                this.close();
                return null;
            });
        }

        public void add(PushLocator.KsqlNode ksqlNode, RoutingResult result) {
            this.results.put(ksqlNode, result);
            if (this.isClosed()) {
                result.close();
            }
        }

        public RoutingResult remove(PushLocator.KsqlNode ksqlNode) {
            return this.results.remove(ksqlNode);
        }

        public Optional<RoutingResult> get(PushLocator.KsqlNode ksqlNode) {
            return Optional.ofNullable(this.results.getOrDefault(ksqlNode, null));
        }

        public void close() {
            this.closed = true;
            for (Map.Entry<PushLocator.KsqlNode, RoutingResult> result : this.results.entrySet()) {
                result.getValue().close();
            }
            this.callback.complete(null);
        }

        public Set<PushLocator.KsqlNode> getAllHosts() {
            return ImmutableSet.copyOf(this.results.keySet());
        }

        public Set<PushLocator.KsqlNode> getActiveHosts() {
            return (Set)this.results.entrySet().stream().filter(e -> RoutingResultStatus.isHostActive(((RoutingResult)e.getValue()).getStatus())).map(Map.Entry::getKey).collect(ImmutableSet.toImmutableSet());
        }

        public boolean isClosed() {
            return this.closed || this.callback.isDone();
        }

        public void onException(Consumer<Throwable> consumer) {
            this.callback.exceptionally(t -> {
                consumer.accept((Throwable)t);
                return null;
            });
        }

        public void completeExceptionally(Throwable throwable) {
            if (!this.callback.isDone()) {
                this.callback.completeExceptionally(throwable);
                this.close();
            }
        }

        public Throwable getError() throws InterruptedException {
            try {
                this.callback.get();
            }
            catch (ExecutionException e) {
                return e.getCause();
            }
            return null;
        }

        public void onCompletionOrException(BiConsumer<Void, Throwable> biConsumer) {
            this.callback.handle((v, t) -> {
                biConsumer.accept((Void)v, (Throwable)t);
                return null;
            });
        }

        public OffsetsTracker getOffsetsTracker() {
            return this.offsetsTracker;
        }
    }

    private static class LocalQueryStreamSubscriber
    extends StreamSubscriber<QueryRow> {
        LocalQueryStreamSubscriber(Context context, TransientQueryQueue transientQueryQueue, CompletableFuture<Void> callback, PushLocator.KsqlNode localNode, QueryId queryId, OffsetsTracker offsetsTracker, PushRoutingOptions pushRoutingOptions, String thisHostName) {
            super(context, transientQueryQueue, callback, localNode, queryId, offsetsTracker, pushRoutingOptions, thisHostName);
        }

        protected synchronized void handleValue(QueryRow row) {
            if (this.closed) {
                return;
            }
            boolean isSourceNode = !this.pushRoutingOptions.getHasBeenForwarded();
            Optional<PushOffsetRange> currentOffsetRange = this.handleContinuationToken(row.getOffsetRange(), isSourceNode, this.pushRoutingOptions.alosEnabled());
            if (!currentOffsetRange.isPresent() && row.getOffsetRange().isPresent()) {
                return;
            }
            if (!currentOffsetRange.isPresent() || this.pushRoutingOptions.shouldOutputContinuationToken()) {
                KeyValueMetadata keyValueMetadata;
                Optional<RowMetadata> rowMetadata = currentOffsetRange.map(RowMetadata::of);
                KeyValueMetadata keyValueMetadata2 = keyValueMetadata = rowMetadata.isPresent() ? new KeyValueMetadata(rowMetadata.get()) : new KeyValueMetadata(new KeyValue(null, (Object)row.value()));
                if (!this.transientQueryQueue.acceptRowNonBlocking(keyValueMetadata)) {
                    this.callback.completeExceptionally(new KsqlException("Hit limit of request queue"));
                    this.close();
                    return;
                }
            } else {
                LOG.debug("Not outputting continuation token " + currentOffsetRange.get());
            }
            this.makeRequest(1L);
        }

        protected void handleError(Throwable t) {
            LOG.error("Received error from remote node {} for id {}: {}", new Object[]{this.node, this.queryId, t.getMessage(), t});
            this.callback.completeExceptionally(t);
            this.close();
        }

        @Override
        public String name() {
            return "Local";
        }
    }

    private static class RemoteStreamSubscriber
    extends StreamSubscriber<StreamedRow> {
        RemoteStreamSubscriber(Context context, TransientQueryQueue transientQueryQueue, CompletableFuture<Void> callback, PushLocator.KsqlNode node, QueryId queryId, OffsetsTracker offsetsTracker, PushRoutingOptions pushRoutingOptions, String thisHostName) {
            super(context, transientQueryQueue, callback, node, queryId, offsetsTracker, pushRoutingOptions, thisHostName);
        }

        protected synchronized void handleValue(StreamedRow row) {
            if (this.closed) {
                return;
            }
            if (row.getFinalMessage().isPresent()) {
                this.close();
                return;
            }
            if (row.getRow().isPresent() || row.getContinuationToken().isPresent()) {
                if (!this.handleQueueableRow(row.getRow(), row.getContinuationToken())) {
                    LOG.warn("Unable to handle queueable row");
                    return;
                }
            } else if (row.getErrorMessage().isPresent()) {
                KsqlErrorMessage errorMessage = (KsqlErrorMessage)row.getErrorMessage().get();
                LOG.error("Received error from remote node {} and id {}: {}", new Object[]{this.node, this.queryId, errorMessage});
                this.callback.completeExceptionally(new KsqlException("Remote server had an error: " + errorMessage.getErrorCode() + " - " + errorMessage.getMessage()));
                this.close();
                return;
            }
            this.makeRequest(1L);
        }

        private boolean handleQueueableRow(Optional<StreamedRow.DataRow> dataRow, Optional<PushContinuationToken> continuationToken) {
            boolean isSourceNode = !this.pushRoutingOptions.getHasBeenForwarded();
            Optional<PushOffsetRange> currentOffsetRange = this.handleContinuationToken(continuationToken.map(t -> PushOffsetRange.deserialize((String)t.getContinuationToken())), isSourceNode, this.pushRoutingOptions.alosEnabled());
            if (continuationToken.isPresent() && !currentOffsetRange.isPresent()) {
                return false;
            }
            if (!currentOffsetRange.isPresent() || this.pushRoutingOptions.shouldOutputContinuationToken()) {
                KeyValueMetadata keyValueMetadata;
                Optional<RowMetadata> rowMetadata = currentOffsetRange.map(RowMetadata::of);
                KeyValueMetadata keyValueMetadata2 = keyValueMetadata = rowMetadata.isPresent() ? new KeyValueMetadata(rowMetadata.get()) : new KeyValueMetadata(new KeyValue(null, (Object)GenericRow.fromList((List)dataRow.get().getColumns())));
                if (!this.transientQueryQueue.acceptRowNonBlocking(keyValueMetadata)) {
                    this.callback.completeExceptionally(new KsqlException("Hit limit of request queue"));
                    this.close();
                    return false;
                }
            } else {
                LOG.debug("Not outputting continuation token " + currentOffsetRange.get());
            }
            return true;
        }

        protected void handleError(Throwable t) {
            LOG.error("Received error from remote node {} for id {}: {}", new Object[]{this.node, this.queryId, t.getMessage(), t});
            LOG.info("Ignoring transient network error for node {} for id {}", (Object)this.node, (Object)this.queryId);
            this.close();
        }

        @Override
        public String name() {
            return "Remote";
        }
    }

    private static abstract class StreamSubscriber<T>
    extends BaseSubscriber<T> {
        protected final TransientQueryQueue transientQueryQueue;
        protected final CompletableFuture<Void> callback;
        protected final PushLocator.KsqlNode node;
        protected final QueryId queryId;
        protected final OffsetsTracker offsetsTracker;
        protected final PushRoutingOptions pushRoutingOptions;
        protected final String thisHostName;
        protected boolean closed;

        StreamSubscriber(Context context, TransientQueryQueue transientQueryQueue, CompletableFuture<Void> callback, PushLocator.KsqlNode node, QueryId queryId, OffsetsTracker offsetsTracker, PushRoutingOptions pushRoutingOptions, String thisHostName) {
            super(context);
            this.transientQueryQueue = transientQueryQueue;
            this.callback = callback;
            this.node = node;
            this.queryId = queryId;
            this.offsetsTracker = offsetsTracker;
            this.pushRoutingOptions = pushRoutingOptions;
            this.thisHostName = thisHostName;
        }

        protected void afterSubscribe(Subscription subscription) {
            this.makeRequest(1L);
        }

        protected void handleComplete() {
            LOG.info("Received complete from remote node {} for id {}", (Object)this.node, (Object)this.queryId);
            this.close();
        }

        synchronized void close() {
            this.closed = true;
            this.callback.complete(null);
            this.context.runOnContext(v -> this.cancel());
        }

        protected Optional<PushOffsetRange> handleContinuationToken(Optional<PushOffsetRange> offsetRangeOptional, boolean isSourceNode, boolean alosEnabled) {
            if (!offsetRangeOptional.isPresent()) {
                return offsetRangeOptional;
            }
            PushOffsetRange offsetRange = offsetRangeOptional.get();
            PushOffsetVector currentOffsets = this.offsetsTracker.getOffsets().copy();
            Preconditions.checkState((boolean)offsetRange.getStartOffsets().isPresent());
            PushOffsetVector startOffsets = currentOffsets.mergeCopy((OffsetVector)offsetRange.getStartOffsets().get());
            PushOffsetVector endOffsets = currentOffsets.mergeCopy((OffsetVector)offsetRange.getEndOffsets());
            PushOffsetRange updatedToken = new PushOffsetRange(Optional.of(startOffsets), endOffsets);
            if (alosEnabled && isSourceNode && !((PushOffsetVector)offsetRange.getStartOffsets().get()).lessThanOrEqualTo((OffsetVector)currentOffsets)) {
                LOG.warn("{}: Found a gap in offsets for {} node {} and id {}: start: {}, current: {}", new Object[]{this.thisHostName, this.name(), this.node, this.queryId, offsetRange.getStartOffsets(), this.offsetsTracker.getOffsets()});
                this.callback.completeExceptionally(new GapFoundException());
                this.close();
                return Optional.empty();
            }
            LOG.debug("{}: Before update with {} current offsets {} and {}", new Object[]{this.thisHostName, this.name(), this.offsetsTracker.getOffsetRange(), new PushOffsetVector()});
            this.offsetsTracker.updateFromToken((OffsetVector)offsetRange.getEndOffsets());
            LOG.debug("{}: Updated {} with {} to have current offsets {}", new Object[]{this.thisHostName, this.name(), offsetRange, this.offsetsTracker.getOffsetRange()});
            return Optional.of(updatedToken);
        }

        public abstract String name();
    }

    public static class RoutingResult {
        private final AutoCloseable closeable;
        private volatile RoutingResultStatus status;

        public RoutingResult(RoutingResultStatus status, AutoCloseable closeable) {
            this.status = status;
            this.closeable = closeable;
        }

        public void close() {
            try {
                this.closeable.close();
            }
            catch (Exception e) {
                LOG.error("Error closing routing result: " + e.getMessage(), (Throwable)e);
            }
        }

        public RoutingResultStatus getStatus() {
            return this.status;
        }

        public void updateStatus(RoutingResultStatus status) {
            this.status = status;
        }

        public String toString() {
            return "RoutingResult{" + (Object)((Object)this.status) + "}";
        }
    }

    public static enum RoutingResultStatus {
        IN_PROGRESS,
        SUCCESS,
        COMPLETE,
        REMOVED,
        FAILED,
        OFFSET_GAP_FOUND;


        static boolean isHostActive(RoutingResultStatus status) {
            switch (status) {
                case IN_PROGRESS: 
                case SUCCESS: {
                    return true;
                }
            }
            return false;
        }
    }
}

