/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.scalablepush;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.ddl.commands.KsqlTopic;
import io.confluent.ksql.execution.scalablepush.ProcessingQueue;
import io.confluent.ksql.execution.scalablepush.consumer.CatchupConsumer;
import io.confluent.ksql.execution.scalablepush.consumer.CatchupCoordinator;
import io.confluent.ksql.execution.scalablepush.consumer.CatchupCoordinatorImpl;
import io.confluent.ksql.execution.scalablepush.consumer.KafkaConsumerFactory;
import io.confluent.ksql.execution.scalablepush.consumer.LatestConsumer;
import io.confluent.ksql.execution.scalablepush.locator.AllHostsLocator;
import io.confluent.ksql.execution.scalablepush.locator.PushLocator;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.PersistentQueryMetadata;
import io.confluent.ksql.util.PushOffsetRange;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Clock;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScalablePushRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(ScalablePushRegistry.class);
    private static final String LATEST_CONSUMER_GROUP_SUFFIX = "_scalable_push_query_latest";
    private static final String CATCHUP_CONSUMER_GROUP_MIDDLE = "_scalable_push_query_catchup_";
    private final PushLocator pushLocator;
    private final LogicalSchema logicalSchema;
    private final boolean isTable;
    private final Map<String, Object> consumerProperties;
    private final KsqlTopic ksqlTopic;
    private final ServiceContext serviceContext;
    private final KsqlConfig ksqlConfig;
    private final String sourceApplicationId;
    private final KafkaConsumerFactory.KafkaConsumerFactoryInterface kafkaConsumerFactory;
    private final LatestConsumer.LatestConsumerFactory latestConsumerFactory;
    private final CatchupConsumer.CatchupConsumerFactory catchupConsumerFactory;
    private final ExecutorService executorService;
    private final ScheduledExecutorService executorServiceCatchup;
    @GuardedBy(value="this")
    private boolean closed = false;
    private AtomicReference<LatestConsumer> latestConsumer = new AtomicReference<Object>(null);
    private CatchupCoordinator catchupCoordinator = new CatchupCoordinatorImpl();
    private Map<QueryId, CatchupConsumer> catchupConsumers = new ConcurrentHashMap<QueryId, CatchupConsumer>();
    @GuardedBy(value="this")
    private boolean stopLatestConsumerOnLastRequest = true;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ScalablePushRegistry(PushLocator pushLocator, LogicalSchema logicalSchema, boolean isTable, Map<String, Object> consumerProperties, KsqlTopic ksqlTopic, ServiceContext serviceContext, KsqlConfig ksqlConfig, String sourceApplicationId, KafkaConsumerFactory.KafkaConsumerFactoryInterface kafkaConsumerFactory, LatestConsumer.LatestConsumerFactory latestConsumerFactory, CatchupConsumer.CatchupConsumerFactory catchupConsumerFactory, ExecutorService executorService, ScheduledExecutorService executorServiceCatchup) {
        this.pushLocator = pushLocator;
        this.logicalSchema = logicalSchema;
        this.isTable = isTable;
        this.consumerProperties = consumerProperties;
        this.ksqlTopic = ksqlTopic;
        this.serviceContext = serviceContext;
        this.ksqlConfig = ksqlConfig;
        this.sourceApplicationId = sourceApplicationId;
        this.kafkaConsumerFactory = kafkaConsumerFactory;
        this.latestConsumerFactory = latestConsumerFactory;
        this.catchupConsumerFactory = catchupConsumerFactory;
        this.executorService = executorService;
        this.executorServiceCatchup = executorServiceCatchup;
    }

    public synchronized void close() {
        if (this.closed) {
            LOG.warn("Already closed registry");
            return;
        }
        LOG.info("Closing scalable push registry for topic " + this.ksqlTopic.getKafkaTopicName());
        LatestConsumer latestConsumer = this.latestConsumer.get();
        if (latestConsumer != null) {
            latestConsumer.closeAsync();
        }
        for (CatchupConsumer catchupConsumer : this.catchupConsumers.values()) {
            catchupConsumer.closeAsync();
        }
        this.catchupConsumers.clear();
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.executorService, (long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.executorServiceCatchup, (long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
        this.closed = true;
    }

    public synchronized void cleanup() {
        this.close();
        this.deleteConsumerGroup(this.getLatestConsumerGroupId());
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void register(ProcessingQueue processingQueue, Optional<CatchupMetadata> catchupMetadata) {
        if (this.closed) {
            throw new IllegalStateException("Shouldn't register after closing");
        }
        try {
            if (catchupMetadata.isPresent()) {
                if (this.catchupConsumers.size() >= this.ksqlConfig.getInt("ksql.query.push.v2.max.catchup.consumers")) {
                    processingQueue.onError();
                    throw new KsqlException("Too many catchups registered, ksql.query.push.v2.max.catchup.consumers:" + this.ksqlConfig.getInt("ksql.query.push.v2.max.catchup.consumers"));
                }
                this.startLatestIfNotRunning(Optional.empty());
                this.startCatchup(processingQueue, catchupMetadata.get());
            } else {
                LatestConsumer latestConsumer = this.latestConsumer.get();
                if (latestConsumer != null && !latestConsumer.isClosed()) {
                    latestConsumer.register(processingQueue);
                } else {
                    this.startLatestIfNotRunning(Optional.of(processingQueue));
                }
            }
        }
        finally {
            this.stopLatestConsumerOnLastRequest();
        }
    }

    public synchronized void unregister(ProcessingQueue processingQueue) {
        if (this.closed) {
            throw new IllegalStateException("Shouldn't unregister after closing");
        }
        try {
            LatestConsumer latestConsumer = this.latestConsumer.get();
            if (latestConsumer != null && !latestConsumer.isClosed()) {
                latestConsumer.unregister(processingQueue);
            }
            this.unregisterCatchup(processingQueue);
        }
        finally {
            this.stopLatestConsumerOnLastRequest();
        }
    }

    public PushLocator getLocator() {
        return this.pushLocator;
    }

    public boolean isTable() {
        return this.isTable;
    }

    public boolean isWindowed() {
        return this.ksqlTopic.getKeyFormat().isWindowed();
    }

    @VisibleForTesting
    public synchronized boolean isLatestRunning() {
        LatestConsumer latestConsumer = this.latestConsumer.get();
        return latestConsumer != null && !latestConsumer.isClosed();
    }

    @VisibleForTesting
    public synchronized boolean anyCatchupsRunning() {
        return this.catchupConsumers.size() > 0;
    }

    @VisibleForTesting
    public int numRegistered() {
        return this.latestNumRegistered() + this.catchupNumRegistered();
    }

    @VisibleForTesting
    public synchronized int latestNumRegistered() {
        LatestConsumer latestConsumer = this.latestConsumer.get();
        if (latestConsumer != null && !latestConsumer.isClosed()) {
            return latestConsumer.numRegistered();
        }
        return 0;
    }

    @VisibleForTesting
    public synchronized long latestNumRowsReceived() {
        LatestConsumer latestConsumer = this.latestConsumer.get();
        if (latestConsumer != null && !latestConsumer.isClosed()) {
            return latestConsumer.getNumRowsReceived();
        }
        return 0L;
    }

    @VisibleForTesting
    public synchronized int catchupNumRegistered() {
        int total = 0;
        for (CatchupConsumer catchupConsumer : this.catchupConsumers.values()) {
            total += catchupConsumer.numRegistered();
        }
        return total;
    }

    @VisibleForTesting
    public synchronized boolean latestHasAssignment() {
        LatestConsumer latestConsumer = this.latestConsumer.get();
        if (latestConsumer != null && !latestConsumer.isClosed()) {
            return latestConsumer.getAssignment() != null;
        }
        return false;
    }

    @VisibleForTesting
    public synchronized void setKeepLatestConsumerOnLastRequest() {
        this.stopLatestConsumerOnLastRequest = false;
    }

    public synchronized void onError() {
    }

    public static Optional<ScalablePushRegistry> create(LogicalSchema logicalSchema, Supplier<List<PersistentQueryMetadata>> allPersistentQueries, boolean isTable, Map<String, Object> streamsProperties, Map<String, Object> consumerProperties, String sourceApplicationId, KsqlTopic ksqlTopic, ServiceContext serviceContext, KsqlConfig ksqlConfig) {
        URL localhost;
        Object appServer = streamsProperties.get("application.server");
        if (appServer == null) {
            return Optional.empty();
        }
        if (!(appServer instanceof String)) {
            throw new IllegalArgumentException("application.server not String");
        }
        try {
            localhost = new URL((String)appServer);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("application.server malformed: '" + appServer + "'");
        }
        AllHostsLocator pushLocator = new AllHostsLocator(allPersistentQueries, localhost);
        return Optional.of(new ScalablePushRegistry(pushLocator, logicalSchema, isTable, consumerProperties, ksqlTopic, serviceContext, ksqlConfig, sourceApplicationId, KafkaConsumerFactory::create, LatestConsumer::new, CatchupConsumer::new, Executors.newSingleThreadExecutor(), Executors.newScheduledThreadPool(ksqlConfig.getInt("ksql.query.push.v2.max.catchup.consumers"))));
    }

    private synchronized boolean stopLatestConsumerOnLastRequest() {
        LatestConsumer latestConsumer = this.latestConsumer.get();
        if (latestConsumer != null && !latestConsumer.isClosed() && latestConsumer.numRegistered() == 0 && this.stopLatestConsumerOnLastRequest && this.catchupConsumers.size() == 0) {
            latestConsumer.closeAsync();
            return true;
        }
        return false;
    }

    private LatestConsumer createLatestConsumer(Optional<ProcessingQueue> processingQueue) {
        KafkaConsumer<Object, GenericRow> consumer = null;
        LatestConsumer latestConsumer = null;
        try {
            consumer = this.kafkaConsumerFactory.create(this.ksqlTopic, this.logicalSchema, this.serviceContext, this.consumerProperties, this.ksqlConfig, this.getLatestConsumerGroupId());
            latestConsumer = this.latestConsumerFactory.create(this.ksqlTopic.getKafkaTopicName(), this.isWindowed(), this.logicalSchema, consumer, this.catchupCoordinator, this::catchupAssignmentUpdater, this.ksqlConfig, Clock.systemUTC());
            return latestConsumer;
        }
        catch (Exception e) {
            LOG.error("Couldn't create latest consumer", (Throwable)e);
            processingQueue.ifPresent(ProcessingQueue::onError);
            if (consumer != null) {
                consumer.close();
            }
            throw e;
        }
    }

    private synchronized void startLatestIfNotRunning(Optional<ProcessingQueue> processingQueue) {
        LatestConsumer latestConsumer = this.latestConsumer.get();
        if (latestConsumer != null && !latestConsumer.isClosed()) {
            return;
        }
        LatestConsumer newLatestConsumer = this.createLatestConsumer(processingQueue);
        processingQueue.ifPresent(newLatestConsumer::register);
        this.latestConsumer.set(newLatestConsumer);
        this.executorService.submit(() -> this.runLatest(newLatestConsumer));
    }

    private void runLatest(LatestConsumer latestConsumerToRun) {
        try (LatestConsumer latestConsumer = latestConsumerToRun;){
            latestConsumer.run();
        }
        catch (Throwable t) {
            LOG.error("Got error while running latest", t);
            latestConsumerToRun.onError();
        }
    }

    private String getLatestConsumerGroupId() {
        return this.sourceApplicationId + LATEST_CONSUMER_GROUP_SUFFIX;
    }

    private synchronized void catchupAssignmentUpdater(Collection<TopicPartition> newAssignment) {
        for (CatchupConsumer catchupConsumer : this.catchupConsumers.values()) {
            catchupConsumer.newAssignment(newAssignment);
        }
    }

    private CatchupConsumer createCatchupConsumer(ProcessingQueue processingQueue, PushOffsetRange offsetRange, String consumerGroup) {
        KafkaConsumer<Object, GenericRow> consumer = null;
        CatchupConsumer catchupConsumer = null;
        try {
            consumer = this.kafkaConsumerFactory.create(this.ksqlTopic, this.logicalSchema, this.serviceContext, this.consumerProperties, this.ksqlConfig, consumerGroup);
            catchupConsumer = this.catchupConsumerFactory.create(this.ksqlTopic.getKafkaTopicName(), this.isWindowed(), this.logicalSchema, consumer, this.latestConsumer::get, this.catchupCoordinator, offsetRange, Clock.systemUTC(), this.ksqlConfig.getLong("ksql.query.push.v2.catchup.consumer.msg.window"), this::unregisterCatchup);
            return catchupConsumer;
        }
        catch (Exception e) {
            LOG.error("Couldn't create catchup consumer", (Throwable)e);
            processingQueue.onError();
            if (consumer != null) {
                consumer.close();
            }
            throw e;
        }
    }

    private synchronized void unregisterCatchup(ProcessingQueue processingQueue) {
        this.catchupConsumers.computeIfPresent(processingQueue.getQueryId(), (queryId, catchupConsumer) -> {
            catchupConsumer.unregister(processingQueue);
            catchupConsumer.closeAsync();
            return null;
        });
    }

    private synchronized void startCatchup(ProcessingQueue processingQueue, CatchupMetadata catchupMetadata) {
        CatchupConsumer catchupConsumer = this.createCatchupConsumer(processingQueue, catchupMetadata.getPushOffsetRange(), catchupMetadata.getCatchupConsumerGroup());
        catchupConsumer.register(processingQueue);
        this.catchupConsumers.put(processingQueue.getQueryId(), catchupConsumer);
        this.executorServiceCatchup.submit(() -> this.runCatchup(catchupConsumer, processingQueue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCatchup(CatchupConsumer catchupConsumerToRun, ProcessingQueue processingQueue) {
        try (CatchupConsumer catchupConsumer = catchupConsumerToRun;){
            catchupConsumer.run();
        }
        catch (Throwable t) {
            LOG.error("Got error while running catchup", t);
            catchupConsumerToRun.onError();
        }
        finally {
            catchupConsumerToRun.unregister(processingQueue);
            this.catchupConsumers.remove(processingQueue.getQueryId());
            this.stopLatestConsumerOnLastRequest();
        }
    }

    public void cleanupCatchupConsumer(String consumerGroup) {
        this.executorServiceCatchup.schedule(() -> this.deleteConsumerGroup(consumerGroup), 5000L, TimeUnit.MILLISECONDS);
    }

    public String getCatchupConsumerId(String suffix) {
        return this.sourceApplicationId + CATCHUP_CONSUMER_GROUP_MIDDLE + suffix;
    }

    private void deleteConsumerGroup(String consumerGroupId) {
        LOG.info("Cleaning up consumer group " + consumerGroupId);
        try {
            Map metadata = this.serviceContext.getConsumerGroupClient().listConsumerGroupOffsets(consumerGroupId);
            if (metadata == null || metadata.values().stream().allMatch(Objects::isNull)) {
                return;
            }
            this.serviceContext.getConsumerGroupClient().deleteConsumerGroups((Set)ImmutableSet.of((Object)consumerGroupId));
        }
        catch (Throwable t) {
            LOG.error("Failed to delete consumer group " + consumerGroupId, t);
        }
    }

    public static class CatchupMetadata {
        private final PushOffsetRange pushOffsetRange;
        private final String catchupConsumerGroup;

        public CatchupMetadata(PushOffsetRange pushOffsetRange, String catchupConsumerGroup) {
            this.pushOffsetRange = pushOffsetRange;
            this.catchupConsumerGroup = catchupConsumerGroup;
        }

        public PushOffsetRange getPushOffsetRange() {
            return this.pushOffsetRange;
        }

        public String getCatchupConsumerGroup() {
            return this.catchupConsumerGroup;
        }
    }
}

