/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.scalablepush.consumer;

import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.ddl.commands.KsqlTopic;
import io.confluent.ksql.logging.processing.NoopProcessingLogContext;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.PhysicalSchema;
import io.confluent.ksql.serde.GenericKeySerDe;
import io.confluent.ksql.serde.GenericRowSerDe;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.serde.WindowInfo;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.util.KsqlConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;

public final class KafkaConsumerFactory {
    private KafkaConsumerFactory() {
    }

    public static KafkaConsumer<Object, GenericRow> create(KsqlTopic ksqlTopic, LogicalSchema logicalSchema, ServiceContext serviceContext, Map<String, Object> consumerProperties, KsqlConfig ksqlConfig, String consumerGroupId) {
        Deserializer<Object> keyDeserializer;
        Serde keySerde;
        PhysicalSchema physicalSchema = PhysicalSchema.from((LogicalSchema)logicalSchema, (SerdeFeatures)ksqlTopic.getKeyFormat().getFeatures(), (SerdeFeatures)ksqlTopic.getValueFormat().getFeatures());
        GenericKeySerDe keySerdeFactory = new GenericKeySerDe();
        if (ksqlTopic.getKeyFormat().getWindowInfo().isPresent()) {
            keySerde = keySerdeFactory.create(ksqlTopic.getKeyFormat().getFormatInfo(), (WindowInfo)ksqlTopic.getKeyFormat().getWindowInfo().get(), physicalSchema.keySchema(), ksqlConfig, serviceContext.getSchemaRegistryClientFactory(), "", NoopProcessingLogContext.INSTANCE, Optional.empty());
            keyDeserializer = KafkaConsumerFactory.getDeserializer(keySerde.deserializer());
        } else {
            keySerde = keySerdeFactory.create(ksqlTopic.getKeyFormat().getFormatInfo(), physicalSchema.keySchema(), ksqlConfig, serviceContext.getSchemaRegistryClientFactory(), "", NoopProcessingLogContext.INSTANCE, Optional.empty());
            keyDeserializer = KafkaConsumerFactory.getDeserializer(keySerde.deserializer());
        }
        GenericRowSerDe valueSerdeFactory = new GenericRowSerDe();
        Serde valueSerde = valueSerdeFactory.create(ksqlTopic.getValueFormat().getFormatInfo(), physicalSchema.valueSchema(), ksqlConfig, serviceContext.getSchemaRegistryClientFactory(), "", NoopProcessingLogContext.INSTANCE, Optional.empty());
        return new KafkaConsumer(KafkaConsumerFactory.consumerConfig(consumerProperties, ksqlConfig, consumerGroupId), keyDeserializer, valueSerde.deserializer());
    }

    private static Deserializer<Object> getDeserializer(Deserializer<?> deserializer) {
        return deserializer;
    }

    public static Map<String, Object> consumerConfig(Map<String, Object> consumerProperties, KsqlConfig ksqlConfig, String consumerGroupId) {
        HashMap<String, Object> config = new HashMap<String, Object>(consumerProperties);
        config.putAll(ksqlConfig.getConsumerClientConfigProps());
        config.put("group.id", consumerGroupId);
        config.put("auto.offset.reset", "latest");
        config.put("isolation.level", "read_committed");
        return config;
    }

    public static interface KafkaConsumerFactoryInterface {
        public KafkaConsumer<Object, GenericRow> create(KsqlTopic var1, LogicalSchema var2, ServiceContext var3, Map<String, Object> var4, KsqlConfig var5, String var6);
    }
}

