/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.scalablepush.consumer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.common.OffsetsRow;
import io.confluent.ksql.execution.common.QueryRow;
import io.confluent.ksql.execution.scalablepush.ProcessingQueue;
import io.confluent.ksql.execution.scalablepush.consumer.RowUtil;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.PushOffsetRange;
import io.confluent.ksql.util.PushOffsetVector;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.consumer.CommitFailedException;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScalablePushConsumer
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ScalablePushConsumer.class);
    private static final Duration POLL_TIMEOUT = Duration.ofMillis(5000L);
    protected final String topicName;
    protected final boolean windowed;
    protected final LogicalSchema logicalSchema;
    protected final KafkaConsumer<Object, GenericRow> consumer;
    protected final Clock clock;
    protected int partitions;
    protected boolean started = false;
    protected AtomicReference<Map<TopicPartition, Long>> currentPositions = new AtomicReference(Collections.emptyMap());
    protected volatile boolean newAssignment = false;
    protected final ConcurrentHashMap<QueryId, ProcessingQueue> processingQueues = new ConcurrentHashMap();
    private volatile boolean closed = false;
    private AtomicLong numRowsReceived = new AtomicLong(0L);
    protected AtomicReference<Set<TopicPartition>> topicPartitions = new AtomicReference();

    public ScalablePushConsumer(String topicName, boolean windowed, LogicalSchema logicalSchema, KafkaConsumer<Object, GenericRow> consumer, Clock clock) {
        this.topicName = topicName;
        this.windowed = windowed;
        this.logicalSchema = logicalSchema;
        this.consumer = consumer;
        this.clock = clock;
    }

    protected abstract void onEmptyRecords();

    protected abstract void afterBatchProcessed();

    protected abstract void onNewAssignment();

    protected abstract void subscribeOrAssign();

    protected void afterOfferedRow(ProcessingQueue queue) {
    }

    public synchronized void newAssignment(Collection<TopicPartition> tps) {
        this.newAssignment = true;
        this.topicPartitions.set((Set<TopicPartition>)(tps != null ? ImmutableSet.copyOf(tps) : null));
        this.notify();
    }

    protected void updateCurrentPositions() {
        this.updateCurrentPositions(Optional.empty());
    }

    protected void updateCurrentPositions(Optional<Map<Integer, Long>> startingOffsets) {
        HashMap<TopicPartition, Long> updatedCurrentPositions = new HashMap<TopicPartition, Long>();
        for (int i = 0; i < this.partitions; ++i) {
            updatedCurrentPositions.put(new TopicPartition(this.topicName, i), -1L);
        }
        for (TopicPartition tp : this.topicPartitions.get()) {
            updatedCurrentPositions.put(tp, startingOffsets.map(offsets -> (Long)offsets.get(tp.partition())).orElse(this.consumer.position(tp)));
        }
        LOG.debug("Consumer has assignment {} and current position {}", this.topicPartitions, updatedCurrentPositions);
        this.currentPositions.set((Map<TopicPartition, Long>)ImmutableMap.copyOf(updatedCurrentPositions));
    }

    private void initialize() {
        this.partitions = this.consumer.partitionsFor(this.topicName).size();
        LOG.info("Found {} partitions for {}", (Object)this.partitions, (Object)this.topicName);
    }

    public void run() {
        if (this.started) {
            LOG.error("Already ran consumer");
            throw new IllegalStateException("Already ran consumer");
        }
        this.started = true;
        try {
            this.initialize();
            this.subscribeOrAssign();
            while (!this.closed) {
                ConsumerRecords records = this.consumer.poll(POLL_TIMEOUT);
                if (this.topicPartitions.get() == null) continue;
                if (this.newAssignment) {
                    this.newAssignment = false;
                    this.onNewAssignment();
                }
                PushOffsetVector startOffsetVector = ScalablePushConsumer.getOffsetVector(this.currentPositions.get(), this.topicName, this.partitions);
                if (records.isEmpty()) {
                    this.updateCurrentPositions();
                    this.computeProgressToken(Optional.of(startOffsetVector));
                    this.onEmptyRecords();
                    continue;
                }
                for (ConsumerRecord rec : records) {
                    this.handleRow(rec.key(), (GenericRow)rec.value(), rec.timestamp());
                }
                this.updateCurrentPositions();
                this.computeProgressToken(Optional.of(startOffsetVector));
                try {
                    this.consumer.commitSync();
                }
                catch (CommitFailedException e) {
                    LOG.warn("Failed to commit, likely due to rebalance.  Will wait for new assignment", (Throwable)e);
                }
                this.afterBatchProcessed();
            }
        }
        catch (WakeupException wakeupException) {
            // empty catch block
        }
    }

    private void computeProgressToken(Optional<PushOffsetVector> givenStartOffsetVector) {
        PushOffsetVector endOffsetVector = ScalablePushConsumer.getOffsetVector(this.currentPositions.get(), this.topicName, this.partitions);
        PushOffsetVector startOffsetVector = givenStartOffsetVector.orElse(endOffsetVector);
        this.handleProgressToken(startOffsetVector, endOffsetVector);
    }

    private static PushOffsetVector getOffsetVector(Map<TopicPartition, Long> offsets, String topic, int numPartitions) {
        ArrayList<Long> offsetList = new ArrayList<Long>();
        for (int i = 0; i < numPartitions; ++i) {
            TopicPartition tp = new TopicPartition(topic, i);
            offsetList.add(offsets.getOrDefault(tp, -1L));
        }
        return new PushOffsetVector(offsetList);
    }

    private void handleProgressToken(PushOffsetVector startOffsetVector, PushOffsetVector endOffsetVector) {
        PushOffsetRange range = new PushOffsetRange(Optional.of(startOffsetVector), endOffsetVector);
        for (ProcessingQueue queue : this.processingQueues.values()) {
            OffsetsRow row = OffsetsRow.of(this.clock.millis(), range);
            queue.offer(row);
        }
    }

    private boolean handleRow(Object key, GenericRow value, long timestamp) {
        if (key == null && !this.logicalSchema.key().isEmpty() || value == null) {
            return false;
        }
        this.numRowsReceived.incrementAndGet();
        for (ProcessingQueue queue : this.processingQueues.values()) {
            try {
                QueryRow row = RowUtil.createRow(key, value, timestamp, this.windowed, this.logicalSchema);
                queue.offer(row);
                this.afterOfferedRow(queue);
            }
            catch (Throwable t) {
                LOG.error("Error while offering row", t);
            }
        }
        return false;
    }

    @Override
    public void close() {
        try {
            this.closeAsync();
        }
        catch (Throwable t) {
            LOG.error("Error closing consumer", t);
        }
        try {
            this.consumer.close();
        }
        catch (Throwable t) {
            LOG.error("Error closing kafka consumer", t);
        }
    }

    public void closeAsync() {
        this.closed = true;
        for (ProcessingQueue processingQueue : this.processingQueues.values()) {
            processingQueue.close();
        }
        this.consumer.wakeup();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void register(ProcessingQueue processingQueue) {
        this.processingQueues.put(processingQueue.getQueryId(), processingQueue);
    }

    public void unregister(ProcessingQueue processingQueue) {
        this.processingQueues.remove(processingQueue.getQueryId());
    }

    public Set<TopicPartition> getAssignment() {
        return this.topicPartitions.get();
    }

    public Map<TopicPartition, Long> getCurrentOffsets() {
        return this.currentPositions.get();
    }

    public PushOffsetVector getCurrentToken() {
        return ScalablePushConsumer.getOffsetVector(this.currentPositions.get(), this.topicName, this.partitions);
    }

    public long getNumRowsReceived() {
        return this.numRowsReceived.get();
    }

    public int numRegistered() {
        return this.processingQueues.size();
    }

    public void onError() {
        for (ProcessingQueue queue : this.processingQueues.values()) {
            queue.onError();
        }
    }
}

