/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.SampledStat;
import org.apache.kafka.common.metrics.stats.WindowedCount;

public final class FunctionMetrics {
    static final String AVG_DESC = "Average time for invocations of the %s";
    static final String MAX_DESC = "Max time for invocations of the %s";
    static final String COUNT_DESC = "Total number of invocations of the %s";
    static final String RATE_DESC = "The rate of invocations (invocations per second) of the %s";

    private FunctionMetrics() {
    }

    public static void initInvocationSensor(Optional<Metrics> metrics, String sensorName, String groupName, String functionDescription) {
        metrics.ifPresent(m -> FunctionMetrics.getInvocationSensor(m, sensorName, groupName, functionDescription));
    }

    public static Sensor getInvocationSensor(Metrics metrics, String sensorName, String groupName, String functionDescription) {
        Sensor sensor = metrics.sensor(sensorName);
        if (sensor.hasMetrics()) {
            return sensor;
        }
        BiFunction<String, String, MetricName> metricNamer = (suffix, descPattern) -> {
            String description = String.format(descPattern, functionDescription);
            return metrics.metricName(sensorName + "-" + suffix, groupName, description);
        };
        sensor.add(metricNamer.apply("avg", AVG_DESC), (MeasurableStat)new Avg());
        sensor.add(metricNamer.apply("max", MAX_DESC), (MeasurableStat)new Max());
        sensor.add(metricNamer.apply("count", COUNT_DESC), (MeasurableStat)new WindowedCount());
        sensor.add(metricNamer.apply("rate", RATE_DESC), (MeasurableStat)new Rate(TimeUnit.SECONDS, (SampledStat)new WindowedCount()));
        return sensor;
    }
}

