/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import io.confluent.ksql.function.AggregateFunctionFactory;
import io.confluent.ksql.function.KsqlScalarFunction;
import io.confluent.ksql.function.KsqlTableFunction;
import io.confluent.ksql.function.MutableFunctionRegistry;
import io.confluent.ksql.function.TableFunctionFactory;
import io.confluent.ksql.function.UdfFactory;
import io.confluent.ksql.name.FunctionName;
import io.confluent.ksql.schema.ksql.SqlArgument;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.ParserKeywordValidatorUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class InternalFunctionRegistry
implements MutableFunctionRegistry {
    private final Map<String, UdfFactory> udfs = new HashMap<String, UdfFactory>();
    private final Map<String, AggregateFunctionFactory> udafs = new HashMap<String, AggregateFunctionFactory>();
    private final Map<String, TableFunctionFactory> udtfs = new HashMap<String, TableFunctionFactory>();
    private final ParserKeywordValidatorUtil functionNameValidator = new ParserKeywordValidatorUtil();

    public synchronized UdfFactory getUdfFactory(FunctionName functionName) {
        UdfFactory udfFactory = this.udfs.get(functionName.text().toUpperCase());
        if (udfFactory == null) {
            throw new KsqlException("Can't find any functions with the name '" + functionName.text() + "'");
        }
        return udfFactory;
    }

    public synchronized void addFunction(KsqlScalarFunction ksqlFunction) {
        UdfFactory udfFactory = this.udfs.get(ksqlFunction.name().text().toUpperCase());
        if (udfFactory == null) {
            throw new KsqlException("Unknown function factory: " + ksqlFunction.name());
        }
        udfFactory.addFunction(ksqlFunction);
    }

    public synchronized UdfFactory ensureFunctionFactory(UdfFactory factory) {
        this.validateFunctionName(factory.getName());
        String functionName = factory.getName().toUpperCase();
        if (this.udafs.containsKey(functionName)) {
            throw new KsqlException("UdfFactory already registered as aggregate: " + functionName);
        }
        if (this.udtfs.containsKey(functionName)) {
            throw new KsqlException("UdfFactory already registered as table function: " + functionName);
        }
        UdfFactory existing = this.udfs.putIfAbsent(functionName, factory);
        if (existing != null && !existing.matches(factory)) {
            throw new KsqlException("UdfFactory not compatible with existing factory. function: " + functionName + " existing: " + existing + ", factory: " + factory);
        }
        return existing == null ? factory : existing;
    }

    public synchronized boolean isAggregate(FunctionName functionName) {
        return this.udafs.containsKey(functionName.text().toUpperCase());
    }

    public synchronized boolean isTableFunction(FunctionName functionName) {
        return this.udtfs.containsKey(functionName.text().toUpperCase());
    }

    public boolean isPresent(FunctionName functionName) {
        if (this.udfs.containsKey(functionName.text().toUpperCase())) {
            return true;
        }
        if (this.udafs.containsKey(functionName.text().toUpperCase())) {
            return true;
        }
        return this.udtfs.containsKey(functionName.text().toUpperCase());
    }

    public synchronized KsqlTableFunction getTableFunction(FunctionName functionName, List<SqlArgument> argumentTypes) {
        TableFunctionFactory udtfFactory = this.udtfs.get(functionName.text().toUpperCase());
        if (udtfFactory == null) {
            throw new KsqlException("No table function with name " + functionName + " exists!");
        }
        return udtfFactory.createTableFunction(argumentTypes);
    }

    public synchronized void addAggregateFunctionFactory(AggregateFunctionFactory aggregateFunctionFactory) {
        String functionName = aggregateFunctionFactory.getName().toUpperCase();
        this.validateFunctionName(functionName);
        if (this.udfs.containsKey(functionName)) {
            throw new KsqlException("Aggregate function already registered as non-aggregate: " + functionName);
        }
        if (this.udtfs.containsKey(functionName)) {
            throw new KsqlException("Aggregate function already registered as table function: " + functionName);
        }
        if (this.udafs.putIfAbsent(functionName, aggregateFunctionFactory) != null) {
            throw new KsqlException("Aggregate function already registered: " + functionName);
        }
    }

    public synchronized void addTableFunctionFactory(TableFunctionFactory tableFunctionFactory) {
        String functionName = tableFunctionFactory.getName().toUpperCase();
        this.validateFunctionName(functionName);
        if (this.udfs.containsKey(functionName)) {
            throw new KsqlException("Table function already registered as non-aggregate: " + functionName);
        }
        if (this.udafs.containsKey(functionName)) {
            throw new KsqlException("Table function already registered as aggregate: " + functionName);
        }
        if (this.udtfs.putIfAbsent(functionName, tableFunctionFactory) != null) {
            throw new KsqlException("Table function already registered: " + functionName);
        }
    }

    public synchronized List<UdfFactory> listFunctions() {
        return new ArrayList<UdfFactory>(this.udfs.values());
    }

    public synchronized AggregateFunctionFactory getAggregateFactory(FunctionName functionName) {
        AggregateFunctionFactory udafFactory = this.udafs.get(functionName.text().toUpperCase());
        if (udafFactory == null) {
            throw new KsqlException("Can not find any aggregate functions with the name '" + functionName + "'");
        }
        return udafFactory;
    }

    public synchronized TableFunctionFactory getTableFunctionFactory(FunctionName functionName) {
        TableFunctionFactory tableFunctionFactory = this.udtfs.get(functionName.text().toUpperCase());
        if (tableFunctionFactory == null) {
            throw new KsqlException("Can not find any table functions with the name '" + functionName + "'");
        }
        return tableFunctionFactory;
    }

    public synchronized List<AggregateFunctionFactory> listAggregateFunctions() {
        return new ArrayList<AggregateFunctionFactory>(this.udafs.values());
    }

    public synchronized List<TableFunctionFactory> listTableFunctions() {
        return new ArrayList<TableFunctionFactory>(this.udtfs.values());
    }

    private void validateFunctionName(String functionName) {
        if (!this.functionNameValidator.test(functionName)) {
            throw new KsqlException(functionName + " is not a valid function name. Function names must be valid java identifiers and not a KSQL reserved word");
        }
    }
}

