/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.function.AggregateFunctionInitArguments;
import io.confluent.ksql.function.FunctionSignature;
import io.confluent.ksql.function.KsqlAggregateFunction;
import io.confluent.ksql.function.ParameterInfo;
import io.confluent.ksql.function.UdafAggregateFunction;
import io.confluent.ksql.function.UdafTableAggregateFunction;
import io.confluent.ksql.function.UdafTypes;
import io.confluent.ksql.function.types.ParamType;
import io.confluent.ksql.function.udaf.TableUdaf;
import io.confluent.ksql.function.udaf.Udaf;
import io.confluent.ksql.name.FunctionName;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.SqlArgument;
import io.confluent.ksql.schema.ksql.SqlTypeParser;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.security.ExtensionSecurityManager;
import io.confluent.ksql.util.KsqlException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.metrics.Metrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UdafFactoryInvoker
implements FunctionSignature {
    private static final Logger LOG = LoggerFactory.getLogger(UdafFactoryInvoker.class);
    private final FunctionName functionName;
    private final Optional<Metrics> metrics;
    private final List<ParamType> paramTypes;
    private final List<ParameterInfo> params;
    private final ParamType aggregateReturnType;
    private final Method method;
    private final String description;
    private final UdafTypes types;
    private final String aggregateSchema;

    UdafFactoryInvoker(Method method, FunctionName functionName, String description, String[] inputSchemas, String aggregateSchema, String outputSchema, SqlTypeParser typeParser, Optional<Metrics> metrics) {
        if (!Udaf.class.equals(method.getReturnType()) && !TableUdaf.class.equals(method.getReturnType())) {
            String functionInfo = String.format("method='%s', functionName='%s', UDFClass='%s'", method.getName(), functionName, method.getDeclaringClass());
            throw new KsqlException("UDAFs must implement " + Udaf.class.getName() + " or " + TableUdaf.class.getName() + ". " + functionInfo);
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new KsqlException("UDAF factory methods must be static " + method);
        }
        this.types = new UdafTypes(method, functionName, typeParser);
        this.functionName = Objects.requireNonNull(functionName);
        this.aggregateSchema = aggregateSchema;
        this.metrics = Objects.requireNonNull(metrics);
        this.params = this.types.getInputSchema(Objects.requireNonNull(inputSchemas));
        this.paramTypes = this.params.stream().map(ParameterInfo::type).collect(Collectors.toList());
        this.aggregateReturnType = this.types.getOutputSchema(Objects.requireNonNull(outputSchema));
        this.method = Objects.requireNonNull(method);
        this.description = Objects.requireNonNull(description);
    }

    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CONSTRAINTS", "REC_CATCH_EXCEPTION"})
    KsqlAggregateFunction createFunction(AggregateFunctionInitArguments initArgs, List<SqlArgument> argTypeList) {
        Object[] factoryArgs = this.method.isVarArgs() ? this.convertToVariadicArgs(initArgs.args().toArray()) : initArgs.args().toArray();
        try {
            ExtensionSecurityManager.INSTANCE.pushInUdf();
            Udaf udaf = (Udaf)this.method.invoke(null, factoryArgs);
            udaf.initializeTypeArguments(argTypeList);
            if (udaf instanceof Configurable) {
                ((Configurable)udaf).configure(initArgs.config());
            }
            SqlType aggregateSqlType = (SqlType)udaf.getAggregateSqlType().orElseGet(() -> SchemaConverters.functionToSqlConverter().toSqlType(this.types.getAggregateSchema(this.aggregateSchema)));
            SqlType returnSqlType = (SqlType)udaf.getReturnSqlType().orElseGet(() -> SchemaConverters.functionToSqlConverter().toSqlType(this.aggregateReturnType));
            UdafAggregateFunction function = TableUdaf.class.isAssignableFrom(this.method.getReturnType()) ? new UdafTableAggregateFunction(this.functionName.text(), initArgs.udafIndices(), udaf, aggregateSqlType, returnSqlType, this.params, this.description, this.metrics, this.method.getName(), this.params.size() - this.literalParams().size()) : new UdafAggregateFunction(this.functionName.text(), initArgs.udafIndices(), udaf, aggregateSqlType, returnSqlType, this.params, this.description, this.metrics, this.method.getName(), this.params.size() - this.literalParams().size());
            UdafAggregateFunction udafAggregateFunction = function;
            return udafAggregateFunction;
        }
        catch (Exception e) {
            LOG.error("Failed to invoke UDAF factory method", (Throwable)e);
            throw new KsqlException("Failed to invoke UDAF factory method", (Throwable)e);
        }
        finally {
            ExtensionSecurityManager.INSTANCE.popOutUdf();
        }
    }

    public FunctionName name() {
        return this.functionName;
    }

    public ParamType declaredReturnType() {
        return this.aggregateReturnType;
    }

    public List<ParamType> parameters() {
        return this.paramTypes;
    }

    public List<ParameterInfo> parameterInfo() {
        return this.params;
    }

    public boolean isVariadic() {
        return this.types.isVariadic();
    }

    public List<ParameterInfo> literalParams() {
        return this.types.literalParams();
    }

    public String getDescription() {
        return this.description;
    }

    private Object[] convertToVariadicArgs(Object[] factoryArgs) {
        int varArgsStartIndex = this.method.getParameterCount() - 1;
        Object[] adjustedFactoryArgs = new Object[this.method.getParameterCount()];
        System.arraycopy(factoryArgs, 0, adjustedFactoryArgs, 0, varArgsStartIndex);
        int numVarArgs = factoryArgs.length - varArgsStartIndex;
        Object[] varArgs = (Object[])Array.newInstance(this.method.getParameterTypes()[varArgsStartIndex].getComponentType(), numVarArgs);
        System.arraycopy(factoryArgs, varArgsStartIndex, varArgs, 0, numVarArgs);
        adjustedFactoryArgs[varArgsStartIndex] = varArgs;
        return adjustedFactoryArgs;
    }
}

