/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udaf.array;

import io.confluent.ksql.function.udaf.TableUdaf;
import io.confluent.ksql.function.udaf.UdafDescription;
import io.confluent.ksql.function.udaf.UdafFactory;
import io.confluent.ksql.schema.ksql.SqlArgument;
import io.confluent.ksql.schema.ksql.types.SqlArray;
import io.confluent.ksql.schema.ksql.types.SqlType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.Configurable;

@UdafDescription(name="collect_list", description="Gather all of the values from an input grouping into a single Array field.\nAlthough this aggregate works on both Stream and Table inputs, the order of entries in the result array is not guaranteed when working on Table input data.\nYou may limit the size of the resultant Array to N entries, beyond which any further values will be silently ignored, by setting the ksql.functions.collect_list.limit configuration to N.", author="Confluent")
public final class CollectListUdaf {
    public static final String LIMIT_CONFIG = "ksql.functions.collect_list.limit";

    private CollectListUdaf() {
    }

    @UdafFactory(description="collect values of a field into a single Array")
    public static <T> TableUdaf<T, List<T>, List<T>> createCollectListT() {
        return new Collect();
    }

    private static final class Collect<T>
    implements TableUdaf<T, List<T>, List<T>>,
    Configurable {
        private int limit = Integer.MAX_VALUE;
        SqlType inputType;

        private Collect() {
        }

        public void configure(Map<String, ?> map) {
            Object limit = map.get(CollectListUdaf.LIMIT_CONFIG);
            if (limit != null) {
                if (limit instanceof Number) {
                    this.limit = ((Number)limit).intValue();
                } else if (limit instanceof String) {
                    this.limit = Integer.parseInt((String)limit);
                }
            }
            if (this.limit < 0) {
                this.limit = Integer.MAX_VALUE;
            }
        }

        public void initializeTypeArguments(List<SqlArgument> argTypeList) {
            this.inputType = argTypeList.get(0).getSqlTypeOrThrow();
        }

        public Optional<SqlType> getAggregateSqlType() {
            return Optional.of(SqlArray.of((SqlType)this.inputType));
        }

        public Optional<SqlType> getReturnSqlType() {
            return Optional.of(SqlArray.of((SqlType)this.inputType));
        }

        public List<T> initialize() {
            return new ArrayList();
        }

        public List<T> aggregate(T thisValue, List<T> aggregate) {
            if (aggregate.size() < this.limit) {
                aggregate.add(thisValue);
            }
            return aggregate;
        }

        public List<T> merge(List<T> aggOne, List<T> aggTwo) {
            int remainingCapacity = this.limit - aggOne.size();
            aggOne.addAll(aggTwo.subList(0, Math.min(remainingCapacity, aggTwo.size())));
            return aggOne;
        }

        public List<T> map(List<T> agg) {
            return agg;
        }

        public List<T> undo(T valueToUndo, List<T> aggregateValue) {
            int lastIndex = aggregateValue.lastIndexOf(valueToUndo);
            if (lastIndex < 0) {
                return aggregateValue;
            }
            aggregateValue.remove(lastIndex);
            return aggregateValue;
        }
    }
}

