/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udaf.attr;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.function.udaf.TableUdaf;
import io.confluent.ksql.function.udaf.UdafDescription;
import io.confluent.ksql.function.udaf.UdafFactory;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.SqlArgument;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

@UdafDescription(name="ATTR", description="The ATTR() aggregation indicates there are multiple values, but only one was expected. For example, if aggregating against a table that semantically should have only one value for a column given a key, this aggregation enables users to indicate that they expect only a single value.\n\nIf the aggregation encounters more than a single value for the expected singular column, the entire aggregation will return null.")
public final class Attr {
    private Attr() {
    }

    @UdafFactory(description="Collect as a singleton")
    public static <T> TableUdaf<T, List<Struct>, T> createAttr() {
        return new Impl();
    }

    @VisibleForTesting
    static class Impl<T>
    implements TableUdaf<T, List<Struct>, T> {
        static final String VALUE = "VALUE";
        static final String COUNT = "COUNT";
        SqlType inType;
        Schema entrySchema;

        Impl() {
        }

        public void initializeTypeArguments(List<SqlArgument> args) {
            this.inType = args.get(0).getSqlTypeOrThrow();
            this.entrySchema = SchemaBuilder.struct().optional().field(VALUE, SchemaConverters.sqlToConnectConverter().toConnectSchema(this.inType)).field(COUNT, Schema.OPTIONAL_INT32_SCHEMA).build();
        }

        public Optional<SqlType> getAggregateSqlType() {
            return Optional.of(SqlTypes.array((SqlType)SchemaConverters.connectToSqlConverter().toSqlType(this.entrySchema)));
        }

        public Optional<SqlType> getReturnSqlType() {
            return Optional.of(this.inType);
        }

        public List<Struct> initialize() {
            return new ArrayList<Struct>();
        }

        public List<Struct> aggregate(T current, List<Struct> agg) {
            ArrayList<Struct> out = new ArrayList<Struct>(agg);
            this.update(out, current, 1);
            return out;
        }

        public List<Struct> merge(List<Struct> one, List<Struct> two) {
            ArrayList<Struct> out = new ArrayList<Struct>(one);
            for (Struct entry : two) {
                this.update(out, entry.get(VALUE), entry.getInt32(COUNT));
            }
            return out;
        }

        public List<Struct> undo(T valueToUndo, List<Struct> agg) {
            ArrayList<Struct> out = new ArrayList<Struct>(agg);
            this.update(out, valueToUndo, -1);
            return out;
        }

        public T map(List<Struct> agg) {
            List collect = agg.stream().filter(s -> s.getInt32(COUNT) > 0).collect(Collectors.toList());
            if (collect.size() != 1) {
                return null;
            }
            return (T)((Struct)collect.get(0)).get(VALUE);
        }

        private void update(List<Struct> agg, Object current, int count) {
            boolean found = false;
            for (Struct entry : agg) {
                if (!Objects.equals(entry.get(VALUE), current)) continue;
                found = true;
                entry.put(COUNT, (Object)Math.max(0, entry.getInt32(COUNT) + count));
                break;
            }
            if (!found && count > 0) {
                agg.add(new Struct(this.entrySchema).put(VALUE, current).put(COUNT, (Object)count));
            }
        }
    }
}

