/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udaf.offset;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.udaf.Udaf;
import io.confluent.ksql.function.udaf.UdafDescription;
import io.confluent.ksql.function.udaf.UdafFactory;
import io.confluent.ksql.function.udaf.offset.KudafByOffsetUtils;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.SqlArgument;
import io.confluent.ksql.schema.ksql.types.SqlArray;
import io.confluent.ksql.schema.ksql.types.SqlType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

@UdafDescription(name="EARLIEST_BY_OFFSET", description="This function returns the oldest N values for the column, computed by offset.", author="Confluent")
public final class EarliestByOffset {
    static final String DESCRIPTION = "This function returns the oldest N values for the column, computed by offset.";
    static final AtomicLong sequence = new AtomicLong();

    private EarliestByOffset() {
    }

    @UdafFactory(description="return the earliest value of a column")
    public static <T> Udaf<T, Struct, T> earliest() {
        return EarliestByOffset.earliest(true);
    }

    @UdafFactory(description="return the earliest value of a column")
    public static <T> Udaf<T, Struct, T> earliest(boolean ignoreNulls) {
        return EarliestByOffset.earliestT(ignoreNulls);
    }

    @UdafFactory(description="return the earliest N values of a column")
    public static <T> Udaf<T, List<Struct>, List<T>> earliest(int earliestN) {
        return EarliestByOffset.earliest(earliestN, true);
    }

    @UdafFactory(description="return the earliest N values of a column")
    public static <T> Udaf<T, List<Struct>, List<T>> earliest(int earliestN, boolean ignoreNulls) {
        return EarliestByOffset.earliestTN(earliestN, ignoreNulls);
    }

    @VisibleForTesting
    static <T> Struct createStruct(Schema schema, T val) {
        return KudafByOffsetUtils.createStruct(schema, EarliestByOffset.generateSequence(), val);
    }

    private static long generateSequence() {
        return sequence.getAndIncrement();
    }

    @VisibleForTesting
    static <T> Udaf<T, Struct, T> earliestT(final boolean ignoreNulls) {
        return new Udaf<T, Struct, T>(){
            Schema structSchema;
            SqlType aggregateType;
            SqlType returnType;

            public void initializeTypeArguments(List<SqlArgument> argTypeList) {
                this.returnType = argTypeList.get(0).getSqlTypeOrThrow();
                Schema connectType = SchemaConverters.sqlToConnectConverter().toConnectSchema(this.returnType);
                this.structSchema = KudafByOffsetUtils.buildSchema(connectType);
                this.aggregateType = SchemaConverters.connectToSqlConverter().toSqlType(this.structSchema);
            }

            public Optional<SqlType> getAggregateSqlType() {
                return Optional.of(this.aggregateType);
            }

            public Optional<SqlType> getReturnSqlType() {
                return Optional.of(this.returnType);
            }

            public Struct initialize() {
                return null;
            }

            public Struct aggregate(T current, Struct aggregate) {
                if (aggregate != null) {
                    return aggregate;
                }
                if (current == null && ignoreNulls) {
                    return null;
                }
                return EarliestByOffset.createStruct(this.structSchema, current);
            }

            public Struct merge(Struct aggOne, Struct aggTwo) {
                if (aggOne == null) {
                    return aggTwo;
                }
                if (aggTwo == null) {
                    return aggOne;
                }
                if (KudafByOffsetUtils.INTERMEDIATE_STRUCT_COMPARATOR.compare(aggOne, aggTwo) < 0) {
                    return aggOne;
                }
                return aggTwo;
            }

            public T map(Struct agg) {
                if (agg == null) {
                    return null;
                }
                return agg.get("VAL");
            }
        };
    }

    @VisibleForTesting
    static <T> Udaf<T, List<Struct>, List<T>> earliestTN(final int earliestN, final boolean ignoreNulls) {
        if (earliestN <= 0) {
            throw new KsqlFunctionException("earliestN must be 1 or greater");
        }
        return new Udaf<T, List<Struct>, List<T>>(){
            Schema structSchema;
            SqlType aggregateType;
            SqlType returnType;

            public void initializeTypeArguments(List<SqlArgument> argTypeList) {
                SqlType inputType = argTypeList.get(0).getSqlTypeOrThrow();
                Schema connectType = SchemaConverters.sqlToConnectConverter().toConnectSchema(inputType);
                this.structSchema = KudafByOffsetUtils.buildSchema(connectType);
                this.aggregateType = SqlArray.of((SqlType)SchemaConverters.connectToSqlConverter().toSqlType(this.structSchema));
                this.returnType = SqlArray.of((SqlType)inputType);
            }

            public Optional<SqlType> getAggregateSqlType() {
                return Optional.of(this.aggregateType);
            }

            public Optional<SqlType> getReturnSqlType() {
                return Optional.of(this.returnType);
            }

            public List<Struct> initialize() {
                return new ArrayList<Struct>(earliestN);
            }

            public List<Struct> aggregate(T current, List<Struct> aggregate) {
                if (current == null && ignoreNulls) {
                    return aggregate;
                }
                if (aggregate.size() < earliestN) {
                    aggregate.add(EarliestByOffset.createStruct(this.structSchema, current));
                }
                return aggregate;
            }

            public List<Struct> merge(List<Struct> aggOne, List<Struct> aggTwo) {
                ArrayList<Struct> merged = new ArrayList<Struct>(aggOne.size() + aggTwo.size());
                merged.addAll(aggOne);
                merged.addAll(aggTwo);
                merged.sort(KudafByOffsetUtils.INTERMEDIATE_STRUCT_COMPARATOR);
                return merged.subList(0, Math.min(earliestN, merged.size()));
            }

            public List<T> map(List<Struct> agg) {
                return agg.stream().map((? super T s) -> s.get("VAL")).collect(Collectors.toList());
            }
        };
    }
}

