/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udaf.sum;

import io.confluent.ksql.function.udaf.TableUdaf;
import io.confluent.ksql.function.udaf.UdafDescription;
import io.confluent.ksql.function.udaf.UdafFactory;
import java.util.List;
import java.util.function.BinaryOperator;

@UdafDescription(name="sum_list", description="Returns the sum of elements contained in the list.", author="Confluent")
public final class ListSumUdaf {
    private ListSumUdaf() {
    }

    @UdafFactory(description="sum double values in a list into a single double")
    public static TableUdaf<List<Double>, Double, Double> sumDoubleList() {
        return new TableUdaf<List<Double>, Double, Double>(){

            public Double initialize() {
                return 0.0;
            }

            public Double aggregate(List<Double> valueToAdd, Double aggregateValue) {
                if (valueToAdd == null) {
                    return aggregateValue;
                }
                return aggregateValue + this.sumList(valueToAdd);
            }

            public Double merge(Double aggOne, Double aggTwo) {
                return aggOne + aggTwo;
            }

            public Double map(Double agg) {
                return agg;
            }

            public Double undo(List<Double> valueToUndo, Double aggregateValue) {
                if (valueToUndo == null) {
                    return aggregateValue;
                }
                return aggregateValue - this.sumList(valueToUndo);
            }

            private double sumList(List<Double> list) {
                return (Double)ListSumUdaf.sum(list, this.initialize(), Double::sum);
            }
        };
    }

    @UdafFactory(description="sum int values in a list into a single int")
    public static TableUdaf<List<Integer>, Integer, Integer> sumIntList() {
        return new TableUdaf<List<Integer>, Integer, Integer>(){

            public Integer initialize() {
                return 0;
            }

            public Integer aggregate(List<Integer> valueToAdd, Integer aggregateValue) {
                if (valueToAdd == null) {
                    return aggregateValue;
                }
                return aggregateValue + this.sumList(valueToAdd);
            }

            public Integer merge(Integer aggOne, Integer aggTwo) {
                return aggOne + aggTwo;
            }

            public Integer map(Integer agg) {
                return agg;
            }

            public Integer undo(List<Integer> valueToUndo, Integer aggregateValue) {
                if (valueToUndo == null) {
                    return aggregateValue;
                }
                return aggregateValue - this.sumList(valueToUndo);
            }

            private int sumList(List<Integer> list) {
                return (Integer)ListSumUdaf.sum(list, this.initialize(), Integer::sum);
            }
        };
    }

    @UdafFactory(description="sum long values in a list into a single long")
    public static TableUdaf<List<Long>, Long, Long> sumLongList() {
        return new TableUdaf<List<Long>, Long, Long>(){

            public Long initialize() {
                return 0L;
            }

            public Long aggregate(List<Long> valueToAdd, Long aggregateValue) {
                if (valueToAdd == null) {
                    return aggregateValue;
                }
                return aggregateValue + this.sumList(valueToAdd);
            }

            public Long merge(Long aggOne, Long aggTwo) {
                return aggOne + aggTwo;
            }

            public Long map(Long agg) {
                return agg;
            }

            public Long undo(List<Long> valueToUndo, Long aggregateValue) {
                if (valueToUndo == null) {
                    return aggregateValue;
                }
                return aggregateValue - this.sumList(valueToUndo);
            }

            private long sumList(List<Long> list) {
                return (Long)ListSumUdaf.sum(list, this.initialize(), Long::sum);
            }
        };
    }

    private static <T> T sum(Iterable<T> list, T initial, BinaryOperator<T> summer) {
        Object sum = initial;
        for (T v : list) {
            if (v == null) continue;
            sum = summer.apply(sum, v);
        }
        return sum;
    }
}

