/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.datetime;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ExecutionException;

@UdfDescription(name="datetostring", category="DATE / TIME", author="Confluent", description="Converts the number of days since 1970-01-01 00:00:00 UTC/GMT to a date string using the given format pattern. Note this is the format Kafka Connect uses to represent dates with no time component.  The format pattern should be in the format expected by java.time.format.DateTimeFormatter. The system default time zone is used when no time zone is explicitly provided.")
public class DateToString {
    private final LoadingCache<String, DateTimeFormatter> formatters = CacheBuilder.newBuilder().maximumSize(1000L).build(CacheLoader.from(DateTimeFormatter::ofPattern));

    @Udf(description="Converts the number of days since 1970-01-01 00:00:00 UTC/GMT to a date string using the given format pattern. The format pattern should be in the format expected by java.time.format.DateTimeFormatter")
    public String dateToString(@UdfParameter(description="The Epoch Day to convert, based on the epoch 1970-01-01") int epochDays, @UdfParameter(description="The format pattern should be in the format expected by java.time.format.DateTimeFormatter.") String formatPattern) {
        if (formatPattern == null) {
            return null;
        }
        try {
            DateTimeFormatter formatter = (DateTimeFormatter)this.formatters.get((Object)formatPattern);
            return LocalDate.ofEpochDay(epochDays).format(formatter);
        }
        catch (RuntimeException | ExecutionException e) {
            throw new KsqlFunctionException("Failed to format date " + epochDays + " with formatter '" + formatPattern + "': " + e.getMessage(), (Throwable)e);
        }
    }
}

