/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.datetime;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.sql.Time;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

@UdfDescription(name="format_time", category="DATE / TIME", author="Confluent", description="Converts a TIME value into the string representation of the time in the given format.")
public class FormatTime {
    private final LoadingCache<String, DateTimeFormatter> formatters = CacheBuilder.newBuilder().maximumSize(1000L).build(CacheLoader.from(DateTimeFormatter::ofPattern));

    @Udf(description="Converts a TIME value into the string representation of the time in the given format. The format pattern should be in the format expected by java.time.format.DateTimeFormatter")
    public String formatTime(@UdfParameter(description="TIME value.") Time time, @UdfParameter(description="The format pattern should be in the format expected by java.time.format.DateTimeFormatter.") String formatPattern) {
        if (time == null || formatPattern == null) {
            return null;
        }
        try {
            DateTimeFormatter formatter = (DateTimeFormatter)this.formatters.get((Object)formatPattern);
            return LocalTime.ofNanoOfDay(TimeUnit.MILLISECONDS.toNanos(time.getTime())).format(formatter);
        }
        catch (RuntimeException | ExecutionException e) {
            throw new KsqlFunctionException("Failed to format time " + LocalTime.ofNanoOfDay(time.getTime() * 1000000L) + " with formatter '" + formatPattern + "': " + e.getMessage(), (Throwable)e);
        }
    }
}

