/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.datetime;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.sql.Time;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

@UdfDescription(name="parse_time", category="DATE / TIME", author="Confluent", description="Converts a string representation of a time in the given format into a TIME value.")
public class ParseTime {
    private final LoadingCache<String, DateTimeFormatter> formatters = CacheBuilder.newBuilder().maximumSize(1000L).build(CacheLoader.from(pattern -> new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern((String)pattern).toFormatter()));

    @Udf(description="Converts a string representation of a time in the given format into the TIME value.")
    public Time parseTime(@UdfParameter(description="The string representation of a time.") String formattedTime, @UdfParameter(description="The format pattern should be in the format expected by java.time.format.DateTimeFormatter.") String formatPattern) {
        if (formattedTime == null | formatPattern == null) {
            return null;
        }
        try {
            TemporalAccessor ta = ((DateTimeFormatter)this.formatters.get((Object)formatPattern)).parse(formattedTime);
            Optional<ChronoField> dateField = Arrays.stream(ChronoField.values()).filter(ChronoField::isDateBased).filter(ta::isSupported).findFirst();
            if (dateField.isPresent()) {
                throw new KsqlFunctionException("Time format contains date field.");
            }
            return new Time(TimeUnit.NANOSECONDS.toMillis(LocalTime.from(ta).toNanoOfDay()));
        }
        catch (RuntimeException | ExecutionException e) {
            throw new KsqlFunctionException("Failed to parse time '" + formattedTime + "' with formatter '" + formatPattern + "': " + e.getMessage(), (Throwable)e);
        }
    }
}

