/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.datetime;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.concurrent.ExecutionException;

@UdfDescription(name="stringtodate", category="DATE / TIME", author="Confluent", description="Converts a string representation of a date in the given format into the number of days since 1970-01-01 00:00:00 UTC/GMT. The system default time zone is used when no time zone is explicitly provided. Note this is the format Kafka Connect uses to represent dates with no time component. The format pattern should be in the format expected by java.time.format.DateTimeFormatter")
public class StringToDate {
    private final LoadingCache<String, DateTimeFormatter> formatters = CacheBuilder.newBuilder().maximumSize(1000L).build(CacheLoader.from(pattern -> new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern((String)pattern).toFormatter()));

    @Udf(description="Converts a string representation of a date in the given format into the number of days since 1970-01-01 00:00:00 UTC/GMT.")
    public int stringToDate(@UdfParameter(description="The string representation of a date.") String formattedDate, @UdfParameter(description="The format pattern should be in the format expected by java.time.format.DateTimeFormatter.") String formatPattern) {
        try {
            DateTimeFormatter formatter = (DateTimeFormatter)this.formatters.get((Object)formatPattern);
            return (int)LocalDate.parse(formattedDate, formatter).toEpochDay();
        }
        catch (RuntimeException | ExecutionException e) {
            throw new KsqlFunctionException("Failed to parse date '" + formattedDate + "' with formatter '" + formatPattern + "': " + e.getMessage(), (Throwable)e);
        }
    }
}

