/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.datetime;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.sql.Timestamp;

@UdfDescription(name="unix_timestamp", category="DATE / TIME", description="Returns the current number of milliseconds for the system since 1970-01-01 00:00:00 UTC/GMT.", author="Confluent")
public class UnixTimestamp {
    @Udf(description="Returns the current number of milliseconds for the system since 1970-01-01 00:00:00 UTC/GMT.")
    public long unixTimestamp() {
        return System.currentTimeMillis();
    }

    @Udf(description="Returns the number of milliseconds since 1970-01-01 00:00:00 UTC/GMT represented by the given timestamp.")
    public Long unixTimestamp(@UdfParameter(description="the TIMESTAMP value.") Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        return timestamp.getTime();
    }
}

