/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.function.udf.json.UdfJsonMapper;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Objects;
import java.util.function.Predicate;

@UdfDescription(name="JSON_ARRAY_CONTAINS", category="JSON", description="Parses a JSON array and determines whether or not the supplied value is contained within the array.", author="Confluent")
public class JsonArrayContains {
    static final String DESCRIPTION = "Parses a JSON array and determines whether or not the supplied value is contained within the array.";
    private static final JsonFactory PARSER_FACTORY = ((JsonFactoryBuilder)new JsonFactoryBuilder().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES)).build().setCodec((ObjectCodec)UdfJsonMapper.INSTANCE);
    private static final EnumMap<JsonToken, Predicate<Object>> TOKEN_COMPAT = new EnumMap(JsonToken.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Udf
    public <T> Boolean contains(@UdfParameter String jsonArray, @UdfParameter T val) {
        try (JsonParser parser = PARSER_FACTORY.createParser(jsonArray);){
            if (parser.nextToken() != JsonToken.START_ARRAY) {
                Boolean bl = false;
                return bl;
            }
            while (parser.nextToken() != null) {
                JsonToken token = parser.currentToken();
                if (token == null) {
                    Boolean bl = val == null;
                    return bl;
                }
                if (token == JsonToken.END_ARRAY) {
                    Boolean bl = false;
                    return bl;
                }
                parser.skipChildren();
                if (!TOKEN_COMPAT.getOrDefault(token, foo -> false).test(val) || token != JsonToken.VALUE_NULL && (val == null || !Objects.equals(parser.readValueAs(val.getClass()), val))) continue;
                Boolean bl = true;
                return bl;
            }
            Boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    static {
        TOKEN_COMPAT.put(JsonToken.VALUE_NUMBER_INT, obj -> obj instanceof Long || obj instanceof Integer);
        TOKEN_COMPAT.put(JsonToken.VALUE_NUMBER_FLOAT, Double.class::isInstance);
        TOKEN_COMPAT.put(JsonToken.VALUE_STRING, String.class::isInstance);
        TOKEN_COMPAT.put(JsonToken.VALUE_TRUE, obj -> obj instanceof Boolean && (Boolean)obj != false);
        TOKEN_COMPAT.put(JsonToken.VALUE_FALSE, obj -> obj instanceof Boolean && (Boolean)obj == false);
        TOKEN_COMPAT.put(JsonToken.VALUE_NULL, Objects::isNull);
    }
}

