/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.json;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.function.udf.json.UdfJsonMapper;
import io.confluent.ksql.schema.ksql.SqlTimeTypes;
import io.confluent.ksql.util.BytesUtils;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Struct;

@UdfDescription(name="TO_JSON_STRING", category="JSON", description="Given any ksqlDB type returns the equivalent JSON string.", author="Confluent")
public class ToJsonString {
    @Udf
    public <T> String toJsonString(@UdfParameter T input) {
        return this.toJson(input);
    }

    private String toJson(Object input) {
        return UdfJsonMapper.writeValueAsJson(this.prepare(input));
    }

    private Object prepare(Object input) {
        if (input instanceof Time) {
            return this.prepareTime((Time)input);
        }
        if (input instanceof Date) {
            return this.prepareDate((Date)input);
        }
        if (input instanceof Timestamp) {
            return this.prepareTimestamp((Timestamp)input);
        }
        if (input instanceof ByteBuffer) {
            return this.prepareByteBuffer((ByteBuffer)input);
        }
        if (input instanceof Struct) {
            return this.prepareStruct((Struct)input);
        }
        if (input instanceof Map) {
            return this.prepareMap((Map)input);
        }
        if (input instanceof List) {
            return this.prepareList((List)input);
        }
        return input;
    }

    private String prepareTime(Time time) {
        return SqlTimeTypes.formatTime((Time)time);
    }

    private String prepareDate(Date date) {
        return SqlTimeTypes.formatDate((Date)date);
    }

    private String prepareTimestamp(Timestamp timestamp) {
        return SqlTimeTypes.formatTimestamp((Timestamp)timestamp);
    }

    private String prepareByteBuffer(ByteBuffer bb) {
        return BytesUtils.encode((byte[])bb.array(), (BytesUtils.Encoding)BytesUtils.Encoding.BASE64);
    }

    private Map<String, Object> prepareStruct(Struct input) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (Field f : input.schema().fields()) {
            map.put(f.name(), this.prepare(input.get(f)));
        }
        return map;
    }

    private Map<String, Object> prepareMap(Map<?, ?> input) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (Map.Entry<?, ?> entry : input.entrySet()) {
            map.put(entry.getKey().toString(), this.prepare(entry.getValue()));
        }
        return map;
    }

    private List<Object> prepareList(List<?> input) {
        ArrayList<Object> lst = new ArrayList<Object>(input.size());
        for (Object o : input) {
            lst.add(this.prepare(o));
        }
        return lst;
    }
}

