/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.lambda;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

@UdfDescription(name="filter", category="LAMBDA", description="Filter the input collection through a given lambda function. The filtered collection is returned.", author="Confluent")
public class Filter {
    @Udf(description="When filtering an array, the function provided must have a boolean result. The function is applied to each value in the array and a filtered array is returned.")
    public <T> List<T> filterArray(@UdfParameter(description="The array") List<T> array, @UdfParameter(description="The lambda function") Function<T, Boolean> function) {
        if (array == null || function == null) {
            return null;
        }
        return array.stream().filter(function::apply).collect(Collectors.toList());
    }

    @Udf(description="When filtering a map, the function provided must have a boolean result. For each map entry, the function will be applied to the key and value arguments in that order. The filtered map is returned.")
    public <K, V> Map<K, V> filterMap(@UdfParameter(description="The map") Map<K, V> map, @UdfParameter(description="The lambda function") BiFunction<K, V, Boolean> biFunction) {
        if (map == null || biFunction == null) {
            return null;
        }
        return map.entrySet().stream().filter(e -> (Boolean)biFunction.apply(e.getKey(), e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

