/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.lambda;

import io.confluent.ksql.execution.codegen.helpers.TriFunction;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

@UdfDescription(name="reduce", category="LAMBDA", description="Reduce the input collection down to a single value using an initial state and a function. The initial state (s) is passed into the scope of the function. Each invocation returns a new value for s, which the next invocation will receive. The final value for s is returned.", author="Confluent")
public class Reduce {
    @Udf(description="When reducing an array, the reduce function must have two arguments. The two arguments for the reduce function are in order: the state and the array item. The final state is returned.")
    public <T, S> S reduceArray(@UdfParameter(description="The array.") List<T> list, @UdfParameter(description="The initial state.") S initialState, @UdfParameter(description="The reduce function.") BiFunction<S, T, S> biFunction) {
        if (initialState == null || biFunction == null) {
            return null;
        }
        if (list == null) {
            return initialState;
        }
        S state = initialState;
        for (T listItem : list) {
            state = biFunction.apply(state, listItem);
        }
        return state;
    }

    @Udf(description="When reducing a map, the reduce function must have three arguments. The three arguments for the reduce function are in order: the state, the key, and the value. The final state is returned.")
    public <K, V, S> S reduceMap(@UdfParameter(description="The map.") Map<K, V> map, @UdfParameter(description="The initial state.") S initialState, @UdfParameter(description="The reduce function.") TriFunction<S, K, V, S> triFunction) {
        if (initialState == null || triFunction == null) {
            return null;
        }
        if (map == null) {
            return initialState;
        }
        Object state = initialState;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            state = triFunction.apply(state, entry.getKey(), entry.getValue());
        }
        return state;
    }
}

