/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.list;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.util.List;

@UdfDescription(name="slice", category="ARRAY", description="slice of an ARRAY", author="Confluent")
public class Slice {
    @Udf
    public <T> List<T> slice(@UdfParameter(description="the input array") List<T> in, @UdfParameter(description="start index") Integer from, @UdfParameter(description="end index") Integer to) {
        if (in == null) {
            return null;
        }
        try {
            int start = from == null ? 0 : from - 1;
            int end = to == null ? in.size() : to.intValue();
            return in.subList(start, end);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }
}

