/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.map;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@UdfDescription(name="map_union", category="MAP", description="Returns a new map containing the union of all entries from both input maps. If a key is present in both input maps then the value from map2 is the one which appears in the result. Returns NULL if all of the input maps are NULL.")
public class MapUnion {
    @Udf
    public <T> Map<String, T> union(@UdfParameter(description="first map to union") Map<String, T> map1, @UdfParameter(description="second map to union") Map<String, T> map2) {
        List<Map> nonNullInputs = Stream.of(map1, map2).filter(Objects::nonNull).collect(Collectors.toList());
        if (nonNullInputs.size() == 0) {
            return null;
        }
        HashMap output = new HashMap();
        nonNullInputs.forEach(output::putAll);
        return output;
    }
}

