/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.math;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;

@UdfDescription(name="cot", category="MATHEMATICAL", author="Confluent", description="The cotangent of a value.")
public class Cot {
    @Udf(description="Returns the cotangent of an INT value")
    public Double cot(@UdfParameter(value="value", description="The value in radians to get the cotangent of.") Integer value) {
        return this.cot(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the cotangent of a BIGINT value")
    public Double cot(@UdfParameter(value="value", description="The value in radians to get the cotangent of.") Long value) {
        return this.cot(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the cotangent of a DOUBLE value")
    public Double cot(@UdfParameter(value="value", description="The value in radians to get the cotangent of.") Double value) {
        return value == null ? null : Double.valueOf(1.0 / Math.tan(value));
    }
}

