/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.math;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;

@UdfDescription(name="power", category="MATHEMATICAL", author="Confluent", description="Given a base and an exponent, returns the result of the base raised to the exponent.")
public class Power {
    @Udf(description="Returns the INT base raised to the INT exponent.")
    public Double power(@UdfParameter(value="base", description="the base of the power.") Integer base, @UdfParameter(value="exponent", description="the exponent of the power.") Integer exponent) {
        return this.power(base == null ? null : Double.valueOf(base.doubleValue()), exponent == null ? null : Double.valueOf(exponent.doubleValue()));
    }

    @Udf(description="Returns the BIGINT base raised to the BIGINT exponent.")
    public Double power(@UdfParameter(value="base", description="the base of the power.") Long base, @UdfParameter(value="exponent", description="the exponent of the power.") Long exponent) {
        return this.power(base == null ? null : Double.valueOf(base.doubleValue()), exponent == null ? null : Double.valueOf(exponent.doubleValue()));
    }

    @Udf(description="Returns the DOUBLE base raised to the DOUBLE exponent.")
    public Double power(@UdfParameter(value="base", description="the base of the power.") Double base, @UdfParameter(value="exponent", description="the exponent of the power.") Double exponent) {
        return base == null || exponent == null ? null : Double.valueOf(Math.pow(base, exponent));
    }
}

