/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.math;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.function.udf.UdfSchemaProvider;
import io.confluent.ksql.schema.ksql.SqlArgument;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlDecimal;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.KsqlException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

@UdfDescription(name="Round", category="MATHEMATICAL", description="Round a value to the number of decimal places as specified by scale to the right of the decimal point. If scale is negative then value is rounded to the right of the decimal point. Numbers equidistant to the nearest value are rounded up (in the positive direction). If the number of decimal places is not provided it defaults to zero.", author="Confluent")
public class Round {
    static final String DESCRIPTION = "Round a value to the number of decimal places as specified by scale to the right of the decimal point. If scale is negative then value is rounded to the right of the decimal point. Numbers equidistant to the nearest value are rounded up (in the positive direction). If the number of decimal places is not provided it defaults to zero.";

    @Udf
    public Long round(@UdfParameter long val) {
        return val;
    }

    @Udf
    public Long round(@UdfParameter int val) {
        return val;
    }

    @Udf
    public Long round(@UdfParameter Double val) {
        return val == null ? null : Long.valueOf(Math.round(val));
    }

    @Udf
    public Double round(@UdfParameter Double val, @UdfParameter Integer decimalPlaces) {
        return val == null || decimalPlaces == null ? null : Double.valueOf(Round.roundBigDecimal(BigDecimal.valueOf(val), decimalPlaces).doubleValue());
    }

    @Udf(schemaProvider="provideDecimalSchema")
    public BigDecimal round(@UdfParameter BigDecimal val) {
        if (val == null) {
            return null;
        }
        return Round.roundBigDecimal(val, 0);
    }

    @Udf(schemaProvider="provideDecimalSchemaWithDecimalPlaces")
    public BigDecimal round(@UdfParameter BigDecimal val, @UdfParameter Integer decimalPlaces) {
        return val == null || decimalPlaces == null ? null : Round.roundBigDecimal(val, decimalPlaces).setScale(val.scale(), RoundingMode.UNNECESSARY);
    }

    @UdfSchemaProvider
    public static SqlType provideDecimalSchemaWithDecimalPlaces(List<SqlArgument> params) {
        SqlType s0 = params.get(0).getSqlTypeOrThrow();
        if (s0.baseType() != SqlBaseType.DECIMAL) {
            throw new KsqlException("The schema provider method for round expects a BigDecimal parametertype as first parameter.");
        }
        SqlType s1 = params.get(1).getSqlTypeOrThrow();
        if (s1.baseType() != SqlBaseType.INTEGER) {
            throw new KsqlException("The schema provider method for round expects an Integer parametertype as second parameter.");
        }
        return s0;
    }

    @UdfSchemaProvider
    public static SqlType provideDecimalSchema(List<SqlArgument> params) {
        SqlType s0 = params.get(0).getSqlTypeOrThrow();
        if (s0.baseType() != SqlBaseType.DECIMAL) {
            throw new KsqlException("The schema provider method for round expects a BigDecimal parametertype as a parameter.");
        }
        SqlDecimal param = (SqlDecimal)s0;
        return SqlDecimal.of((int)(param.getPrecision() - param.getScale()), (int)0);
    }

    private static BigDecimal roundBigDecimal(BigDecimal val, int decimalPlaces) {
        RoundingMode roundingMode = val.compareTo(BigDecimal.ZERO) > 0 ? RoundingMode.HALF_UP : RoundingMode.HALF_DOWN;
        return val.setScale(decimalPlaces, roundingMode);
    }
}

