/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.math;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;

@UdfDescription(name="sinh", category="MATHEMATICAL", author="Confluent", description="The hyperbolic sine of a value.")
public class Sinh {
    @Udf(description="Returns the hyperbolic sine of an INT value")
    public Double sinh(@UdfParameter(value="value", description="The value in radians to get the hyperbolic sine of.") Integer value) {
        return this.sinh(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the hyperbolic sine of a BIGINT value")
    public Double sinh(@UdfParameter(value="value", description="The value in radians to get the hyperbolic sine of.") Long value) {
        return this.sinh(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Returns the hyperbolic sine of a DOUBLE value")
    public Double sinh(@UdfParameter(value="value", description="The value in radians to get the hyperbolic sine of.") Double value) {
        return value == null ? null : Double.valueOf(Math.sinh(value));
    }
}

