/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.string;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import org.apache.commons.lang3.StringEscapeUtils;

@UdfDescription(name="Chr", category="STRING", description="Returns a single-character string corresponding to the input character code.")
public class Chr {
    @Udf
    public String chr(@UdfParameter(description="Decimal codepoint") Integer decimalCode) {
        if (decimalCode == null) {
            return null;
        }
        if (!Character.isValidCodePoint(decimalCode)) {
            return null;
        }
        char[] resultChars = Character.toChars(decimalCode);
        return String.valueOf(resultChars);
    }

    @Udf
    public String chr(@UdfParameter(description="UTF16 code for the desired character e.g. '\\u004b'") String utf16Code) {
        if (utf16Code == null || utf16Code.length() < 6 || !utf16Code.startsWith("\\u")) {
            return null;
        }
        return StringEscapeUtils.unescapeJava((String)utf16Code);
    }
}

