/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.string;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;

@UdfDescription(name="elt", category="STRING", description="ELT() returns the Nth element of the list of strings. Returns NULL if N is less than 1 or greater than the number of arguments. Note that this method is 1-indexed. This is the complement to FIELD.", author="Confluent")
public class Elt {
    static final String DESCRIPTION = "ELT() returns the Nth element of the list of strings. Returns NULL if N is less than 1 or greater than the number of arguments. Note that this method is 1-indexed. This is the complement to FIELD.";

    @Udf
    public String elt(@UdfParameter(description="the nth element to extract") int n, String ... args) {
        if (args == null) {
            return null;
        }
        if (n < 1 || n > args.length) {
            return null;
        }
        return args[n - 1];
    }
}

