/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.string;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import org.apache.commons.lang3.StringUtils;

@UdfDescription(name="instr", category="STRING", author="Confluent", description="Returns the position of substring in the provided string")
public class Instr {
    @Udf
    public int instr(String str, String substring) {
        return this.instr(str, substring, 1);
    }

    @Udf
    public int instr(String str, String substring, int position) {
        return this.instr(str, substring, position, 1);
    }

    @Udf
    public int instr(String str, String substring, int position, int occurrence) {
        if (str == null || substring == null) {
            return 0;
        }
        if (Math.abs(position) > str.length()) {
            return 0;
        }
        if (position < 0) {
            String reversedStr = StringUtils.reverse((String)str);
            String reversedSubstring = StringUtils.reverse((String)substring);
            return this.find(reversedStr, reversedSubstring, position * -1, occurrence, true);
        }
        return this.find(str, substring, position, occurrence, false);
    }

    private int find(String str, String substring, int position, int occurence, boolean reversed) {
        int i = StringUtils.ordinalIndexOf((CharSequence)StringUtils.substring((String)str, (int)(position - 1)), (CharSequence)substring, (int)occurence);
        if (i == -1) {
            return 0;
        }
        return reversed ? str.length() - position - i - substring.length() + 2 : i + position;
    }
}

