/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.string;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.util.BytesUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;

@UdfDescription(name="LPad", category="STRING", description="Pads the input string or bytes, starting from the beginning, with the specified padding string until the target length is reached. If the input string or bytes are longer than the specified target length it will be truncated. If the padding string or bytes are empty or NULL, or the target length is negative, then NULL is returned.")
public class LPad {
    @Udf
    public String lpad(@UdfParameter(description="String to be padded") String input, @UdfParameter(description="Target length") Integer targetLen, @UdfParameter(description="Padding string") String padding) {
        if (input == null) {
            return null;
        }
        if (padding == null || padding.isEmpty() || targetLen == null || targetLen < 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(targetLen + padding.length());
        int padUpTo = Math.max(targetLen - input.length(), 0);
        for (int i = 0; i < padUpTo; i += padding.length()) {
            sb.append(padding);
        }
        sb.setLength(padUpTo);
        sb.append(input);
        sb.setLength(targetLen);
        return sb.toString();
    }

    @Udf
    public ByteBuffer lpad(@UdfParameter(description="Bytes to be padded") ByteBuffer input, @UdfParameter(description="Target length") Integer targetLen, @UdfParameter(description="Padding bytes") ByteBuffer padding) {
        if (input == null) {
            return null;
        }
        if (padding == null || padding.capacity() == 0 || targetLen == null || targetLen < 0) {
            return null;
        }
        byte[] start = BytesUtils.getByteArray((ByteBuffer)input);
        if (start.length > targetLen) {
            return ByteBuffer.wrap(Arrays.copyOfRange(start, 0, (int)targetLen));
        }
        byte[] padded = new byte[targetLen.intValue()];
        byte[] paddingArray = BytesUtils.getByteArray((ByteBuffer)padding);
        for (int i = 0; i < targetLen; ++i) {
            int padUpTo = targetLen - start.length;
            if (i >= padUpTo) {
                padded[i] = start[i - padUpTo];
                continue;
            }
            int paddingIndex = i % paddingArray.length;
            padded[i] = paddingArray[paddingIndex];
        }
        return ByteBuffer.wrap(padded);
    }
}

