/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.string;

import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

@UdfDescription(name="regexp_extract_all", category="REGULAR EXPRESSION", author="Confluent", description="Extracts the all subtrings matched by a regex pattern")
public class RegexpExtractAll {
    @Udf(description="Returns all substrings of the input that matches the given regex pattern")
    public List<String> regexpExtractAll(@UdfParameter(description="The regex pattern") String pattern, @UdfParameter(description="The input string to apply regex on") String input) {
        return this.regexpExtractAll(pattern, input, 0);
    }

    @Udf(description="Returns all substrings of the input that matches the regex pattern and the capturing group number specified")
    public List<String> regexpExtractAll(@UdfParameter(description="The regex pattern") String pattern, @UdfParameter(description="The input string to apply regex on") String input, @UdfParameter(description="The capturing group number") Integer group) {
        if (pattern == null || input == null || group == null) {
            return null;
        }
        Pattern p = this.getPattern(pattern);
        Matcher m = p.matcher(input);
        if (group > m.groupCount()) {
            return null;
        }
        ArrayList<String> matches = new ArrayList<String>();
        while (m.find()) {
            matches.add(m.group(group));
        }
        return matches;
    }

    private Pattern getPattern(String regexp) {
        try {
            return Pattern.compile(regexp);
        }
        catch (PatternSyntaxException e) {
            throw new KsqlFunctionException("Invalid regular expression pattern: " + regexp, (Throwable)e);
        }
    }
}

