/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.string;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.util.BytesUtils;
import java.nio.ByteBuffer;

@UdfDescription(name="to_bytes", category="STRING", description="Converts a STRING value in the specified encoding to BYTES. The accepted encoders are 'hex', 'utf8', 'ascii', and 'base64'.", author="Confluent")
public class ToBytes {
    @Udf(description="Converts a STRING value in the specified encoding to BYTES. The accepted encoders are 'hex', 'utf8', 'ascii', and 'base64'.")
    public ByteBuffer toBytes(@UdfParameter(description="The string to convert.") String value, @UdfParameter(description="The type of encoding.") String encoding) {
        return value == null || encoding == null ? null : ByteBuffer.wrap(BytesUtils.decode((String)value, (BytesUtils.Encoding)BytesUtils.Encoding.from((String)encoding)));
    }
}

