/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner.plan;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.expression.tree.ColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.QualifiedColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.planner.Projection;
import io.confluent.ksql.planner.RequiredColumns;
import io.confluent.ksql.planner.plan.PlanBuildContext;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.planner.plan.PlanNodeId;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.SystemColumns;
import io.confluent.ksql.services.KafkaTopicClient;
import io.confluent.ksql.structured.SchemaKSourceFactory;
import io.confluent.ksql.structured.SchemaKStream;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Immutable
public class DataSourceNode
extends PlanNode {
    private static final String SOURCE_OP_NAME = "Source";
    private final DataSource dataSource;
    private final SchemaKStreamFactory schemaKStreamFactory;
    private final LogicalSchema schema;
    private final boolean isWindowed;

    public DataSourceNode(PlanNodeId id, DataSource dataSource, SourceName alias, boolean isWindowed) {
        this(id, dataSource, alias, SchemaKSourceFactory::buildSource, isWindowed);
    }

    DataSourceNode(PlanNodeId id, DataSource dataSource, SourceName alias, SchemaKStreamFactory schemaKStreamFactory, boolean isWindowed) {
        super(id, dataSource.getDataSourceType(), Optional.of(alias));
        this.dataSource = Objects.requireNonNull(dataSource, "dataSource");
        this.schema = DataSourceNode.buildSchema(dataSource);
        this.schemaKStreamFactory = Objects.requireNonNull(schemaKStreamFactory, "schemaKStreamFactory");
        this.isWindowed = isWindowed;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public SourceName getAlias() {
        return this.getSourceName().orElseThrow(IllegalStateException::new);
    }

    public DataSource.DataSourceType getDataSourceType() {
        return this.dataSource.getDataSourceType();
    }

    @Override
    public LogicalSchema getSchema() {
        return this.schema;
    }

    @Override
    public int getPartitions(KafkaTopicClient kafkaTopicClient) {
        String topicName = this.dataSource.getKsqlTopic().getKafkaTopicName();
        return kafkaTopicClient.describeTopic(topicName).partitions().size();
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of();
    }

    public boolean isWindowed() {
        return this.isWindowed;
    }

    @Override
    public SchemaKStream<?> buildStream(PlanBuildContext buildContext) {
        QueryContext.Stacker contextStacker = buildContext.buildNodeContext(this.getId().toString());
        return this.schemaKStreamFactory.create(buildContext, this.dataSource, contextStacker.push(new String[]{SOURCE_OP_NAME}));
    }

    @Override
    public Stream<ColumnName> resolveSelectStar(Optional<SourceName> sourceName) {
        if (sourceName.isPresent() && !sourceName.equals(this.getSourceName())) {
            throw new IllegalArgumentException("Expected alias of " + this.getAlias() + ", but was " + sourceName.get());
        }
        return DataSourceNode.orderColumns(this.getSchema().value(), this.getSchema());
    }

    @Override
    void validateKeyPresent(SourceName sinkName, Projection projection) {
        if (this.getSchema().key().isEmpty()) {
            return;
        }
        List keys = this.getSchema().key();
        for (Column keyCol : keys) {
            ColumnName keyName = keyCol.name();
            if (projection.containsExpression((Expression)new QualifiedColumnReferenceExp(this.getAlias(), keyName)) || projection.containsExpression((Expression)new UnqualifiedColumnReferenceExp(keyName))) continue;
            DataSourceNode.throwKeysNotIncludedError(sinkName, "key column", keys.stream().map(Column::name).map(UnqualifiedColumnReferenceExp::new).collect(Collectors.toList()));
        }
    }

    @Override
    public Set<ColumnReferenceExp> validateColumns(RequiredColumns requiredColumns) {
        return requiredColumns.get().stream().filter(this::nonKnownColumn).collect(Collectors.toSet());
    }

    private boolean nonKnownColumn(ColumnReferenceExp columnRef) {
        if (columnRef.maybeQualifier().isPresent() && !((SourceName)columnRef.maybeQualifier().get()).equals((Object)this.getAlias())) {
            return true;
        }
        ColumnName columnName = columnRef.getColumnName();
        if (SystemColumns.isPseudoColumn((ColumnName)columnName)) {
            return false;
        }
        if (SystemColumns.isWindowBound((ColumnName)columnName)) {
            return !this.dataSource.getKsqlTopic().getKeyFormat().isWindowed();
        }
        return !this.dataSource.getSchema().findColumn(columnName).isPresent();
    }

    private static LogicalSchema buildSchema(DataSource dataSource) {
        return dataSource.getSchema().withPseudoAndKeyColsInValue(dataSource.getKsqlTopic().getKeyFormat().isWindowed());
    }

    @Immutable
    static interface SchemaKStreamFactory {
        public SchemaKStream<?> create(PlanBuildContext var1, DataSource var2, QueryContext.Stacker var3);
    }
}

