/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner.plan;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import io.confluent.ksql.execution.expression.tree.ColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.planner.Projection;
import io.confluent.ksql.planner.RequiredColumns;
import io.confluent.ksql.planner.plan.DataSourceNode;
import io.confluent.ksql.planner.plan.PlanBuildContext;
import io.confluent.ksql.planner.plan.PlanNodeId;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.SystemColumns;
import io.confluent.ksql.services.KafkaTopicClient;
import io.confluent.ksql.structured.SchemaKStream;
import io.confluent.ksql.util.GrammaticalJoiner;
import io.confluent.ksql.util.KsqlException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class PlanNode {
    private final PlanNodeId id;
    private final DataSource.DataSourceType nodeOutputType;
    private final Optional<SourceName> sourceName;

    protected PlanNode(PlanNodeId id, DataSource.DataSourceType nodeOutputType, Optional<SourceName> sourceName) {
        this.id = Objects.requireNonNull(id, "id");
        this.nodeOutputType = Objects.requireNonNull(nodeOutputType, "nodeOutputType");
        this.sourceName = Objects.requireNonNull(sourceName, "sourceName");
    }

    public final PlanNodeId getId() {
        return this.id;
    }

    public final DataSource.DataSourceType getNodeOutputType() {
        return this.nodeOutputType;
    }

    public abstract LogicalSchema getSchema();

    public abstract List<PlanNode> getSources();

    public DataSourceNode getLeftmostSourceNode() {
        return (DataSourceNode)Iterables.getOnlyElement((Iterable)this.getSourceNodes().limit(1L).collect(Collectors.toList()));
    }

    public Stream<DataSourceNode> getSourceNodes() {
        if (this instanceof DataSourceNode) {
            return Stream.of((DataSourceNode)this);
        }
        return this.getSources().stream().flatMap(PlanNode::getSourceNodes);
    }

    protected abstract int getPartitions(KafkaTopicClient var1);

    public abstract SchemaKStream<?> buildStream(PlanBuildContext var1);

    Optional<SourceName> getSourceName() {
        return this.sourceName;
    }

    public Stream<ColumnName> resolveSelectStar(Optional<SourceName> sourceName) {
        return this.getSources().stream().filter(s -> !sourceName.isPresent() || !s.getSourceName().isPresent() || sourceName.equals(s.getSourceName())).flatMap(s -> s.resolveSelectStar(sourceName));
    }

    public Expression resolveSelect(int idx, Expression expression) {
        return expression;
    }

    protected Set<ColumnReferenceExp> validateColumns(RequiredColumns requiredColumns) {
        return ((PlanNode)Iterables.getOnlyElement(this.getSources())).validateColumns(requiredColumns);
    }

    void validateKeyPresent(SourceName sinkName, Projection projection) {
        this.getSources().forEach(s -> s.validateKeyPresent(sinkName, projection));
    }

    static void throwKeysNotIncludedError(SourceName sinkName, String type, List<? extends Expression> requiredKeys) {
        PlanNode.throwKeysNotIncludedError(sinkName, type, requiredKeys, true, false);
    }

    static void throwKeysNotIncludedError(SourceName sinkName, String type, List<? extends Expression> requiredKeys, boolean requireAll, boolean synthetic) {
        String keyPostfix = requireAll && requiredKeys.size() > 1 ? "s" : "";
        String types = type + (requiredKeys.size() == 1 ? "" : "s");
        String joined = (requireAll ? GrammaticalJoiner.and() : GrammaticalJoiner.or()).join(requiredKeys);
        String additional1 = synthetic ? "See https://cnfl.io/2LV7ouS." : "";
        String additional2 = synthetic ? System.lineSeparator() + Iterables.getOnlyElement(requiredKeys) + " was added as a synthetic key column because the join criteria did not match any source column. This expression must be included in the projection and may be aliased. " : "";
        throw new KsqlException("Key" + keyPostfix + " missing from projection (ie, SELECT). " + additional1 + System.lineSeparator() + "The query used to build " + sinkName + " must include the " + types + " " + joined + " in its projection (eg, SELECT " + (requireAll ? GrammaticalJoiner.comma().join(requiredKeys) : requiredKeys.stream().findFirst().get()) + "...)." + additional2);
    }

    static Stream<ColumnName> orderColumns(List<Column> columns, LogicalSchema schema) {
        ImmutableMap columnsByName = Maps.uniqueIndex(columns, Column::name);
        Stream<Column> keys = schema.key().stream().map(key -> (Column)columnsByName.get((Object)key.name())).filter(Objects::nonNull);
        Stream<Column> windowBounds = columns.stream().filter(c -> SystemColumns.isWindowBound((ColumnName)c.name()));
        Stream<Column> values = columns.stream().filter(c -> !SystemColumns.isWindowBound((ColumnName)c.name())).filter(c -> !SystemColumns.isPseudoColumn((ColumnName)c.name())).filter(c -> !schema.isKeyColumn(c.name()));
        return Streams.concat((Stream[])new Stream[]{keys, windowBounds, values}).map(Column::name);
    }
}

