/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner.plan;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.analyzer.RewrittenAnalysis;
import io.confluent.ksql.execution.codegen.CodeGenRunner;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.interpreter.InterpretedExpressionFactory;
import io.confluent.ksql.execution.plan.SelectExpression;
import io.confluent.ksql.execution.transform.ExpressionEvaluator;
import io.confluent.ksql.execution.util.ExpressionTypeManager;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.parser.tree.AllColumns;
import io.confluent.ksql.parser.tree.SelectItem;
import io.confluent.ksql.planner.Projection;
import io.confluent.ksql.planner.QueryPlannerOptions;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.planner.plan.PlanNodeId;
import io.confluent.ksql.planner.plan.ProjectNode;
import io.confluent.ksql.planner.plan.QueryLogicalPlanUtil;
import io.confluent.ksql.planner.plan.SelectionUtil;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.SystemColumns;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class QueryProjectNode
extends ProjectNode {
    private final Projection projection;
    private final ImmutableList<SelectExpression> selectExpressions;
    private final LogicalSchema outputSchema;
    private final LogicalSchema intermediateSchema;
    private final ImmutableList<ExpressionEvaluator> compiledSelectExpressions;
    private final RewrittenAnalysis analysis;
    private final QueryPlannerOptions queryPlannerOptions;
    private final boolean isScalablePush;
    private final boolean isSelectStar;
    private final boolean addAdditionalColumnsToIntermediateSchema;
    private final KsqlConfig ksqlConfig;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public QueryProjectNode(PlanNodeId id, PlanNode source, List<SelectItem> selectItems, MetaStore metaStore, KsqlConfig ksqlConfig, RewrittenAnalysis analysis, boolean isWindowed, QueryPlannerOptions queryPlannerOptions, boolean isScalablePush) {
        super(id, source);
        this.ksqlConfig = Objects.requireNonNull(ksqlConfig, "ksqlConfig");
        this.projection = Projection.of(selectItems);
        this.analysis = Objects.requireNonNull(analysis, "analysis");
        this.queryPlannerOptions = Objects.requireNonNull(queryPlannerOptions, "queryPlannerOptions");
        this.isScalablePush = isScalablePush;
        this.selectExpressions = ImmutableList.copyOf(SelectionUtil.buildSelectExpressions(this.getSource(), this.projection.selectItems(), Optional.empty()));
        this.isSelectStar = this.isSelectStar();
        this.addAdditionalColumnsToIntermediateSchema = this.shouldAddAdditionalColumnsInSchema();
        this.outputSchema = this.buildOutputSchema(metaStore);
        this.intermediateSchema = QueryLogicalPlanUtil.buildIntermediateSchema(source.getSchema().withoutPseudoAndKeyColsInValue(), this.addAdditionalColumnsToIntermediateSchema, isWindowed);
        this.compiledSelectExpressions = this.isSelectStar ? ImmutableList.of() : (ImmutableList)this.selectExpressions.stream().map(selectExpression -> QueryProjectNode.getExpressionEvaluator(selectExpression.getExpression(), this.intermediateSchema, metaStore, ksqlConfig, queryPlannerOptions)).collect(ImmutableList.toImmutableList());
    }

    @Override
    public LogicalSchema getSchema() {
        return this.outputSchema;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="selectExpressions is ImmutableList")
    public List<SelectExpression> getSelectExpressions() {
        return this.selectExpressions;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="compiledSelectExpressions is ImmutableList")
    public List<ExpressionEvaluator> getCompiledSelectExpressions() {
        if (this.isSelectStar) {
            throw new IllegalStateException("Select expressions aren't compiled for select star");
        }
        return this.compiledSelectExpressions;
    }

    public LogicalSchema getIntermediateSchema() {
        return this.intermediateSchema;
    }

    public boolean getIsSelectStar() {
        return this.isSelectStar;
    }

    public boolean getAddAdditionalColumnsToIntermediateSchema() {
        return this.addAdditionalColumnsToIntermediateSchema;
    }

    private LogicalSchema buildOutputSchema(MetaStore metaStore) {
        LogicalSchema parentSchema = this.getSource().getSchema();
        boolean isWindowed = this.analysis.getFrom().getDataSource().getKsqlTopic().getKeyFormat().isWindowed();
        LogicalSchema outputSchema = this.isSelectStar() ? this.buildPullQuerySelectStarSchema(parentSchema.withoutPseudoAndKeyColsInValue(), isWindowed) : this.selectOutputSchema(metaStore, (List<SelectExpression>)this.selectExpressions, isWindowed);
        if (this.isScalablePush) {
            LogicalSchema.Builder builder = LogicalSchema.builder();
            outputSchema.columns().forEach(arg_0 -> ((LogicalSchema.Builder)builder).valueColumn(arg_0));
            return builder.build();
        }
        return outputSchema;
    }

    private boolean shouldAddAdditionalColumnsInSchema() {
        boolean hasSystemColumns = this.analysis.getSelectColumnNames().stream().anyMatch(columnName -> SystemColumns.isSystemColumn((ColumnName)columnName));
        boolean hasKeyColumns = this.analysis.getSelectColumnNames().stream().anyMatch(cn -> this.getSource().getSchema().isKeyColumn(cn));
        boolean hasHeaderColumns = this.analysis.getSelectColumnNames().stream().anyMatch(cn -> this.getSource().getSchema().isHeaderColumn(cn));
        return hasSystemColumns || hasKeyColumns || hasHeaderColumns || this.isSelectStar;
    }

    private boolean isSelectStar() {
        boolean someStars = this.projection.selectItems().stream().anyMatch(s -> s instanceof AllColumns);
        if (someStars && this.projection.selectItems().size() != 1) {
            String queryType = this.isScalablePush ? "Scalable push" : "Pull";
            throw new KsqlException(queryType + " queries only support wildcards in the projects if they are the only expression");
        }
        return someStars;
    }

    private LogicalSchema buildPullQuerySelectStarSchema(LogicalSchema schema, boolean windowed) {
        LogicalSchema.Builder builder = LogicalSchema.builder().keyColumns((Iterable)schema.key());
        if (windowed) {
            builder.keyColumn(SystemColumns.WINDOWSTART_NAME, (SqlType)SqlTypes.BIGINT);
            builder.keyColumn(SystemColumns.WINDOWEND_NAME, (SqlType)SqlTypes.BIGINT);
        }
        return builder.headerColumns((Iterable)schema.headers()).valueColumns((Iterable)schema.value()).build();
    }

    private LogicalSchema selectOutputSchema(MetaStore metaStore, List<SelectExpression> selectExpressions, boolean isWindowed) {
        LogicalSchema.Builder schemaBuilder = LogicalSchema.builder();
        LogicalSchema parentSchema = this.getSource().getSchema();
        LogicalSchema schema = parentSchema.withPseudoAndKeyColsInValue(isWindowed);
        ExpressionTypeManager expressionTypeManager = new ExpressionTypeManager(schema, (FunctionRegistry)metaStore);
        for (SelectExpression select : selectExpressions) {
            SqlType type = expressionTypeManager.getExpressionSqlType(select.getExpression());
            if (parentSchema.isKeyColumn(select.getAlias()) || select.getAlias().equals((Object)SystemColumns.WINDOWSTART_NAME) || select.getAlias().equals((Object)SystemColumns.WINDOWEND_NAME)) {
                schemaBuilder.keyColumn(select.getAlias(), type);
                continue;
            }
            schemaBuilder.valueColumn(select.getAlias(), type);
        }
        return schemaBuilder.build();
    }

    private static ExpressionEvaluator getExpressionEvaluator(Expression expression, LogicalSchema schema, MetaStore metaStore, KsqlConfig ksqlConfig, QueryPlannerOptions queryPlannerOptions) {
        if (queryPlannerOptions.getInterpreterEnabled()) {
            return InterpretedExpressionFactory.create((Expression)expression, (LogicalSchema)schema, (FunctionRegistry)metaStore, (KsqlConfig)ksqlConfig);
        }
        return CodeGenRunner.compileExpression((Expression)expression, (String)"Select", (LogicalSchema)schema, (KsqlConfig)ksqlConfig, (FunctionRegistry)metaStore);
    }
}

