/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.properties;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.config.KsqlConfigResolver;
import io.confluent.ksql.parser.tree.SetProperty;
import io.confluent.ksql.parser.tree.UnsetProperty;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.util.KsqlStatementException;
import java.util.Map;

public final class PropertyOverrider {
    private PropertyOverrider() {
    }

    public static void set(ConfiguredStatement<SetProperty> statement, Map<String, Object> mutableProperties) {
        SetProperty setProperty = statement.getStatement();
        PropertyOverrider.throwIfInvalidProperty(setProperty.getPropertyName(), statement.getMaskedStatementText());
        PropertyOverrider.throwIfInvalidPropertyValues(setProperty, statement);
        mutableProperties.put(setProperty.getPropertyName(), setProperty.getPropertyValue());
    }

    public static void unset(ConfiguredStatement<UnsetProperty> statement, Map<String, Object> mutableProperties) {
        UnsetProperty unsetProperty = statement.getStatement();
        PropertyOverrider.throwIfInvalidProperty(unsetProperty.getPropertyName(), statement.getMaskedStatementText());
        mutableProperties.remove(unsetProperty.getPropertyName());
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_INFERRED"})
    private static void throwIfInvalidPropertyValues(SetProperty setProperty, ConfiguredStatement<SetProperty> statement) {
        try {
            statement.getSessionConfig().getConfig(false).cloneWithPropertyOverwrite((Map)ImmutableMap.of((Object)setProperty.getPropertyName(), (Object)setProperty.getPropertyValue()));
        }
        catch (Exception e) {
            throw new KsqlStatementException(e.getMessage(), statement.getMaskedStatementText(), e.getCause());
        }
    }

    private static void throwIfInvalidProperty(String propertyName, String text) {
        new KsqlConfigResolver().resolve(propertyName, true).orElseThrow(() -> new KsqlStatementException("Unknown property: " + propertyName, text));
    }
}

