/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.query;

import io.confluent.ksql.properties.PropertiesUtil;
import io.confluent.ksql.query.KafkaStreamsBuilder;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.processor.internals.namedtopology.KafkaStreamsNamedTopologyWrapper;

public class KafkaStreamsBuilderImpl
implements KafkaStreamsBuilder {
    private final KafkaClientSupplier clientSupplier;

    KafkaStreamsBuilderImpl(KafkaClientSupplier clientSupplier) {
        this.clientSupplier = Objects.requireNonNull(clientSupplier, "clientSupplier");
    }

    @Override
    public KafkaStreams build(Topology topology, Map<String, Object> conf) {
        return new KafkaStreams(topology, PropertiesUtil.asProperties(conf), this.clientSupplier);
    }

    @Override
    public KafkaStreamsNamedTopologyWrapper buildNamedTopologyWrapper(Map<String, Object> conf) {
        return new KafkaStreamsNamedTopologyWrapper(PropertiesUtil.asProperties(conf), this.clientSupplier);
    }
}

